/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.internal.values.ValueImpl;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TupleValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public class TupleValueImpl
extends ValueImpl
implements TupleValue {
    public static final int TUPLE_VALUE_FEATURE_COUNT = 0;
    protected final @NonNull TupleTypeId tupleTypeId;
    private final @Nullable Object @NonNull [] partValues;
    private Integer hashCode = null;

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.TUPLE_VALUE;
    }

    protected TupleValueImpl() {
        throw new UnsupportedOperationException();
    }

    public TupleValueImpl(@NonNull TupleTypeId tupleTypeId, @NonNull Map<@NonNull ? extends TuplePartId, @Nullable Object> values) {
        this.tupleTypeId = tupleTypeId;
        this.partValues = new Object[tupleTypeId.getPartIds().length];
        for (Map.Entry<? extends TuplePartId, Object> entry : values.entrySet()) {
            this.partValues[entry.getKey().getIndex()] = entry.getValue();
        }
    }

    public TupleValueImpl(@NonNull TupleTypeId tupleTypeId, Object ... values) {
        this.tupleTypeId = tupleTypeId;
        TuplePartId[] partIds = tupleTypeId.getPartIds();
        if (partIds.length != values.length) {
            throw new InvalidValueException("Mismatching tuple values", new Object[0]);
        }
        this.partValues = new Object[partIds.length];
        int i = 0;
        while (i < values.length) {
            this.partValues[i] = values[i];
            ++i;
        }
    }

    @Override
    public @NonNull Object asObject() {
        return this.partValues;
    }

    @Override
    public @NonNull TupleValue asTupleValue() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleValueImpl)) {
            return false;
        }
        TupleValueImpl that = (TupleValueImpl)o;
        if (this.tupleTypeId != that.tupleTypeId) {
            return false;
        }
        @Nullable Object @NonNull [] partValues2 = this.partValues;
        int i = 0;
        while (i < partValues2.length) {
            Object thisPart = partValues2[i];
            Object thatPart = that.partValues[i];
            if (thisPart == null ? thatPart != null : !thisPart.equals(thatPart)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public @NonNull TupleTypeId getTypeId() {
        return this.tupleTypeId;
    }

    @Override
    public @Nullable Object getValue(@NonNull TuplePartId partId) {
        return this.getValue(partId.getIndex());
    }

    @Override
    public @Nullable Object getValue(int index) {
        return this.partValues[index];
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int hash = this.tupleTypeId.hashCode();
            Object[] objectArray = this.partValues;
            int n = this.partValues.length;
            int n2 = 0;
            while (n2 < n) {
                @Nullable Object partValue = objectArray[n2];
                hash = 37 * hash + (partValue != null ? partValue.hashCode() : 0);
                ++n2;
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int sizeLimit) {
        s.append("Tuple{");
        TuplePartId[] partIds = this.tupleTypeId.getPartIds();
        int i = 0;
        while (i < partIds.length) {
            TuplePartId partId = partIds[i];
            if (i != 0) {
                s.append(", ");
            }
            s.append(partId.getDisplayName());
            s.append(" = ");
            ValueUtil.toString(this.partValues[i], s, 40);
            ++i;
        }
        s.append("}");
    }
}

