/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationResult;

public class EvaluationResult
implements IEvaluationResult {
    private IJavaValue fValue;
    private IJavaThread fThread;
    private IEvaluationEngine fEngine;
    private String fSnippet;
    private DebugException fException;
    private List<String> fErrors;
    private boolean fTerminated = false;

    public EvaluationResult(IEvaluationEngine engine, String snippet, IJavaThread thread) {
        this.setEvaluationEngine(engine);
        this.setThread(thread);
        this.setSnippet(snippet);
        this.fErrors = new ArrayList<String>();
    }

    @Override
    public IJavaValue getValue() {
        return this.fValue;
    }

    public void setValue(IJavaValue value) {
        this.fValue = value;
    }

    @Override
    public boolean hasErrors() {
        return this.getErrors().length > 0 || this.getException() != null;
    }

    @Override
    @Deprecated
    public Message[] getErrors() {
        Message[] messages = new Message[this.fErrors.size()];
        int i = 0;
        for (String errMsg : this.fErrors) {
            messages[i++] = new Message(errMsg, -1);
        }
        return messages;
    }

    @Override
    public String[] getErrorMessages() {
        return this.fErrors.toArray(new String[this.fErrors.size()]);
    }

    @Override
    public String getSnippet() {
        return this.fSnippet;
    }

    private void setSnippet(String snippet) {
        this.fSnippet = snippet;
    }

    @Override
    public DebugException getException() {
        return this.fException;
    }

    public void setException(DebugException e) {
        this.fException = e;
    }

    @Override
    public IJavaThread getThread() {
        return this.fThread;
    }

    private void setThread(IJavaThread thread) {
        this.fThread = thread;
    }

    @Override
    public IEvaluationEngine getEvaluationEngine() {
        return this.fEngine;
    }

    private void setEvaluationEngine(IEvaluationEngine engine) {
        this.fEngine = engine;
    }

    public void addError(String message) {
        this.fErrors.add(message);
    }

    @Override
    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }
}

