/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.ui.hover

import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider
import expressions.Expression
import expressions.Declaration
import timing.FixedValue
import timing.Array
import timing.TriangularDistribution
import timing.PertDistribution
import timing.NormalDistribution
import timing.EnumeratedDistribution
import setting.PhysicalLocation
import setting.impl.LocationSettingsMapEntryImpl
import setting.impl.MotionArgumentsMapEntryImpl
import setting.impl.MotionSettingsMapEntryImpl

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
class SettingHoverProvider extends DefaultEObjectHoverProvider {

    override String getFirstLine(EObject o) {
        val parent = o.eContainer
        val def = switch(parent){
            LocationSettingsMapEntryImpl: parent.key.name
            MotionSettingsMapEntryImpl: parent.key.name
            MotionArgumentsMapEntryImpl: parent.key
            default: super.getFirstLine(o)
        }
        val value = toString(o)
        if (value !== null) {
            return def + " = " + value;
        }
        return def;
    }

    override hasHover(EObject o) {
        return toString(o) !== null || super.hasHover(o);
    }

    private def toString(EObject o) {
        if (o instanceof Declaration) {
            return o.expression?.evaluate;
        }
        if (o instanceof PhysicalLocation) {
            return o.^default;
        }
        if (o instanceof FixedValue) {
            return o.value;
        }
        if (o instanceof Array) {
            return o.values.join('[' + ',' + ']');
        }
        if (o instanceof TriangularDistribution) {
            return o.^default;
        }
        if (o instanceof PertDistribution) {
            return '''{min=«o.min», max=«o.max», mode=«o.mode», gamma=«o.gamma», default=«o.^default»}'''
        }
        if (o instanceof NormalDistribution) {
            return '''{mean=«o.mean», sd=«o.sd», default=«o.^default»}'''
        }
        if (o instanceof EnumeratedDistribution) {
            return o.values.join('[' + ',' + ']');
        }
        if (o instanceof Expression) {
            return o.evaluate;
        }
        return null
    }
}
