/*
 * Decompiled with CFR 0.152.
 */
package machine.impl;

import java.util.Objects;
import java.util.Set;
import machine.Axis;
import machine.Path;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.Profile;
import machine.SetPoint;
import machine.SymbolicPosition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.IterableUtil;

public final class MachineQueries {
    private MachineQueries() {
    }

    public static final PathTargetReference findPath(SymbolicPosition source, SymbolicPosition target, Profile profile) {
        return (PathTargetReference)QueryableIterable.from(source.getOutgoingPaths()).select(p -> p.getProfiles().contains((Object)profile)).collect(Path::getTargets).any(t -> t.getPosition() == target);
    }

    public static final Set<Profile> getAvailableProfiles(SymbolicPosition source, SymbolicPosition target) {
        return QueryableIterable.from(source.getOutgoingPaths()).select(p -> IterableUtil.contains((Iterable)QueryableIterable.from(p.getTargets()).collectOne(PathTargetReference::getPosition), (Object)target)).collect(Path::getProfiles).asOrderedSet();
    }

    public static Axis getAxis(Peripheral peripheral, String axisName) {
        return (Axis)QueryableIterable.from(peripheral.getType().getAxes()).any(x -> Objects.equals(axisName, x.getName()));
    }

    public static SetPoint getSetPoint(Peripheral peripheral, String setPointName) {
        return (SetPoint)QueryableIterable.from(peripheral.getType().getSetPoints()).any(x -> Objects.equals(setPointName, x.getName()));
    }

    public static final Set<Path> findTargetReference(SymbolicPosition source) {
        EList<Path> p1 = source.getPeripheral().getPaths();
        return QueryableIterable.from(p1).select(p -> source.getTargetReferences().containsAll(p.getTargets())).asOrderedSet();
    }
}

