/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.dispatching.teditor.scoping

import activity.ResourceAction
import dispatching.Dispatch
import dispatching.DispatchGroup
import machine.ResourceItem
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.scoping.impl.FilteringScope

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it 
 * 
 */
class DispatchingScopeProvider extends AbstractDeclarativeScopeProvider {
//    If you want to log the queried scoping rules, just enable this error handler
//    new() {
//        errorHandler = new PolymorphicDispatcher.ErrorHandler<IScope> {
//            override handle(Object[] params, Throwable throwable) {
//                System.err.println(throwable.message)
//                return null
//            }
//        }
//    }
    /** 
     * Allow for shortName (@link ResourceItem name)
     */
    def IScope scope_ResourceItem(Dispatch dis, EReference ref) {
        if (dis.activity === null)
            return IScope.NULLSCOPE;
        val eligibleItems = dis.activity.resourcesNeedingItem.flatMap[items].toSet
        val validNameItems = eligibleItems.groupBy[name].values.filter[size == 1].flatten.toSet
        val fqns = eligibleItems.map[fqn].toSet
        return Scopes.scopeFor(validNameItems, new FilteringScope(delegateGetScope(dis, ref), [
            fqns.contains(it.qualifiedName.toString)
        ]));
    }

    def IScope ResourceYieldMapEntry(DispatchGroup dg, EReference ref) {
        if (dg.dispatches === null)
            return IScope.NULLSCOPE;
        return Scopes.scopeFor(dg.dispatches.flatMap[activity.nodes].filter(ResourceAction).map[resource].toSet)
    }
}
