/*
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.lsat.machine.design;

import static org.eclipse.lsat.common.queries.QueryableIterable.from;

import org.eclipse.emf.common.util.EList;

import machine.Path;
import machine.Profile;

public class MachineService {
    public String getProfileNames(Path path) {
        return from(path.getProfiles()).collectOne(Profile::getName).joinfields(", ", "", "");
    }

    public Path updateProfilesBasedOnDirectEdit(Path path, String profilesString) {
        String[] profilesSpecifiedinTheDiagram = profilesString.trim().split(",");
        EList<Profile> profilesAvailableFromTheModel = path.getPeripheral().getProfiles();

        if (profilesSpecifiedinTheDiagram.length < profilesAvailableFromTheModel.size()) {
            path.getProfiles().retainAll(from(profilesSpecifiedinTheDiagram).xcollect(
                    pStr -> from(profilesAvailableFromTheModel).select(p -> pStr.trim().equals(p.getName().trim())))
                    .asList());
        } else {
            path.getProfiles().addAll((from(profilesSpecifiedinTheDiagram).xcollect(
                    pStr -> from(profilesAvailableFromTheModel).select(p -> pStr.trim().equals(p.getName().trim())))
                    .asList()));
        }

        return path;
    }
}
