/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking.random;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.meanpayoff.solvers.policy.PolicyIterationDouble;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTGraph;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.meanpayoff.MPGDoubleImplJGraphT;

public class BenchmarkRandomDoubleGraphs {
    private BenchmarkRandomDoubleGraphs() {
    }

    public static MPGDoubleImplJGraphT constructGameGraphImpl() {
        JGraphTGraph paperGraph = new JGraphTGraph();
        HashSet<JGraphTVertex> list = new HashSet<JGraphTVertex>();
        int n = 10;
        int w = 100;
        int i = 0;
        while (i < n) {
            JGraphTVertex v = new JGraphTVertex();
            list.add(v);
            if (i % 2 == 0) {
                paperGraph.addToV0(v);
            } else {
                paperGraph.addToV1(v);
            }
            ++i;
        }
        SingleWeightFunctionDouble<JGraphTEdge> wf = new SingleWeightFunctionDouble<JGraphTEdge>();
        for (JGraphTVertex latestVertex : list) {
            Iterator fastI = list.iterator();
            while (fastI.next() != latestVertex) {
            }
            while (fastI.hasNext()) {
                JGraphTVertex temp = (JGraphTVertex)fastI.next();
                Random r = new Random();
                Double rand1 = 1.0 + ((double)w - 1.0) * r.nextDouble();
                Double rand2 = 1.0 + ((double)w - 1.0) * r.nextDouble();
                BenchmarkRandomDoubleGraphs.addEdge(paperGraph, wf, latestVertex, temp, rand1);
                BenchmarkRandomDoubleGraphs.addEdge(paperGraph, wf, temp, latestVertex, rand2);
            }
        }
        return new MPGDoubleImplJGraphT(paperGraph, wf);
    }

    public static void runBenchmark() {
        int i = 0;
        while (i < 10) {
            MPGDoubleImplJGraphT game = BenchmarkRandomDoubleGraphs.constructGameGraphImpl();
            long start = System.nanoTime();
            Tuple<Map<JGraphTVertex, Double>, StrategyVector<JGraphTVertex, JGraphTEdge>> resultPI = PolicyIterationDouble.solve(game);
            long end = System.nanoTime();
            System.out.println("Solved using policy iteration: " + (double)(end - start) / 1.0E9 + " sec");
            ++i;
        }
        System.out.println("Finished!");
    }

    public static void main(String[] args) {
        BenchmarkRandomDoubleGraphs.runBenchmark();
    }

    private static void addEdge(JGraphTGraph g, SingleWeightFunctionDouble<JGraphTEdge> wf, JGraphTVertex src, JGraphTVertex target, Double weight) {
        JGraphTEdge e = g.addEdge(src, target);
        wf.addWeight(e, weight);
    }
}

