/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.games.StrategyVector;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.Benchmark;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator.Tor;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.PolicyIterationDoubleVars;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTVertex;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class TorEpsDeltaFuzzyBenchmark
extends Benchmark {
    private final String name;
    private final Integer sizeMin;
    private final Integer sizeMax;
    private final Integer stepSize;
    private final Integer maxWeight1;
    private final Integer maxWeight2;
    private PrintWriter file;

    public TorEpsDeltaFuzzyBenchmark(String name, Integer sizeMin, Integer sizeMax, Integer stepSize, Integer maxWeight1, Integer maxWeight2) {
        this.name = name;
        this.sizeMin = sizeMin;
        this.sizeMax = sizeMax;
        this.stepSize = stepSize;
        this.maxWeight1 = maxWeight1;
        this.maxWeight2 = maxWeight2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run(Integer numberOfIterations, boolean runPI, boolean runEG, boolean runZP) {
        this.file = this.getFile(this.name);
        this.file.printf("%s,%s,%s,%s,%s\n", "N", "maxWeight1", "maxWeight2", "PolicyIterationN", "PolicyIterationR");
        System.out.printf("%s,%s,%s,%s,%s\n", "N", "maxWeight1", "maxWeight2", "PolicyIterationN", "PolicyIterationR");
        int runId = 0;
        while (runId < numberOfIterations) {
            int v = this.sizeMin;
            while (v <= this.sizeMax) {
                this.runAlgorithmsTor(v, this.maxWeight1, this.maxWeight2);
                v += this.stepSize.intValue();
            }
            ++runId;
        }
        this.file.close();
    }

    private void runAlgorithmsTor(Integer size, Integer maxWeight1, Integer maxWeight2) {
        RGIntImplJGraphT torGraph = Tor.generateRatioGame(size, maxWeight1, maxWeight2);
        RGDoubleImplJGraphT torGraphD = this.toDoubleGameGraph(torGraph);
        Integer vSize = torGraphD.getVertices().size();
        Double epsilon = 1.0E-9;
        Double delta = (double)(vSize - 1) * torGraphD.getMaxAbsValue() * epsilon;
        long start = System.nanoTime();
        Tuple<Map<JGraphTVertex, Double>, StrategyVector<JGraphTVertex, JGraphTEdge>> doubleResult = PolicyIterationDoubleVars.solve(torGraphD, epsilon, delta);
        long end = System.nanoTime();
        float piSecD = (float)(end - start) / 1.0E9f;
        this.file.printf("%d,%d,%d,%f\n", size, maxWeight1, maxWeight2, Float.valueOf(piSecD));
        System.out.printf("%d,%d,%d,%f\n", size, maxWeight1, maxWeight2, Float.valueOf(piSecD));
    }

    private RGDoubleImplJGraphT toDoubleGameGraph(RGIntImplJGraphT ratioGame) {
        DoubleWeightFunctionInt<JGraphTEdge> f = ratioGame.getEdgeWeights();
        DoubleWeightFunctionDouble<JGraphTEdge> weights = new DoubleWeightFunctionDouble<JGraphTEdge>();
        for (JGraphTEdge e : ratioGame.getEdges()) {
            weights.addWeight(e, (double)((Integer)f.getWeight1((Object)e)).intValue() * 0.62, (double)((Integer)f.getWeight2((Object)e)).intValue() * 0.34);
        }
        return new RGDoubleImplJGraphT(ratioGame.getGraph(), weights);
    }
}

