/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.datastructures.weights;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunction;

public class DoubleWeightFunctionDouble<E>
implements DoubleWeightFunction<Double, E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<E, Double> weight1Map = new HashMap<E, Double>();
    private final Map<E, Double> weight2Map = new HashMap<E, Double>();
    private Double min1Value = Double.POSITIVE_INFINITY;
    private Double min2Value;
    private Double max1Value = Double.NEGATIVE_INFINITY;
    private Double max2Value;
    private Double maxAbsValue = 0.0;

    public DoubleWeightFunctionDouble() {
        this.min2Value = Double.POSITIVE_INFINITY;
        this.max2Value = Double.NEGATIVE_INFINITY;
    }

    public void addWeight(E edge, double weight1, double weight2) {
        this.weight1Map.put(edge, weight1);
        this.weight2Map.put(edge, weight2);
        this.min1Value = Math.min(this.min1Value, weight1);
        this.max1Value = Math.max(this.max1Value, weight1);
        this.min2Value = Math.min(this.min2Value, weight2);
        this.max2Value = Math.max(this.max2Value, weight2);
        this.maxAbsValue = Math.max(this.maxAbsValue, Math.abs(weight1));
        this.maxAbsValue = Math.max(this.maxAbsValue, Math.abs(weight2));
    }

    @Override
    public Double getWeight1(E edge) {
        return this.weight1Map.get(edge);
    }

    @Override
    public Double getWeight2(E edge) {
        return this.weight2Map.get(edge);
    }

    public Double getMin1Value() {
        return this.min1Value;
    }

    public Double getMax1Value() {
        return this.max1Value;
    }

    public Double getMin2Value() {
        return this.min1Value;
    }

    public Double getMax2Value() {
        return this.max1Value;
    }

    @Override
    public Double getMaxAbsValue() {
        return this.maxAbsValue;
    }
}

