/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
/*
 * generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.formatting2;

import activity.Activity
import activity.ActivitySet
import activity.Claim
import activity.LocationPrerequisite
import activity.Move
import activity.Release
import activity.SimpleAction
import com.google.inject.Inject
import machine.Import
import org.eclipse.lsat.common.graph.directed.editable.Edge
import org.eclipse.lsat.common.graph.directed.editable.Node
import org.eclipse.lsat.common.graph.directed.editable.SourceReference
import org.eclipse.lsat.common.graph.directed.editable.TargetReference
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess
import org.eclipse.xtext.formatting2.AbstractFormatter2
import org.eclipse.xtext.formatting2.IFormattableDocument

import static activity.ActivityPackage.Literals.*

class ActivityFormatter extends AbstractFormatter2 {

    @Inject extension ActivityGrammarAccess

    def dispatch void format(ActivitySet activityset, extension IFormattableDocument document) {
        // Enable the line below to see the document's formatting elements.
        // println(textRegionAccess)
        for (Import imports : activityset.getImports()) {
            imports.prepend[noSpace]
        }
        for (Activity activities : activityset.getActivities()) {
            activities?.format
        }
    }

    def dispatch void format(LocationPrerequisite prerequisite, extension IFormattableDocument document) {
        prerequisite.prepend[newLine]
        prerequisite.regionFor.keyword(locationPrerequisiteAccess.atKeyword_3).surround[oneSpace]
    }

    def dispatch void format(Activity activity, extension IFormattableDocument document) {
        activity.prepend[newLines = 2]
        activity.regionFor.keyword(activityAccess.activityKeyword_0).append[oneSpace]
        

        val openActivity = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_2)
        val closeActivity = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_12)

        openActivity.surround[oneSpace]
        interior(openActivity, closeActivity)[indent]

        // Format prerequisites
        activity.regionFor.keyword(activityAccess.prerequisitesKeyword_3_0).prepend[newLine]
        val openPrerequisites = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_3_1)
        val closePrerequisites = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_3_3)
        
        openPrerequisites.prepend[oneSpace].append[newLine]
        closePrerequisites.prepend[newLine].append[newLine]
        interior(openPrerequisites,closePrerequisites)[indent]
        for (prerequisite : activity.prerequisites) {
            prerequisite?.format
        }
        
        // Format actions block.
        activity.regionFor.keyword(activityAccess.actionsKeyword_4).prepend[newLine]
        val openActions = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_5)
        val closeActions = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_7)

        openActions.prepend[oneSpace].append[newLine]
        closeActions.prepend[newLine].append[newLine]
        interior(openActions, closeActions)[indent]

        // Format action flow
        val openActionFlow = activity.regionFor.keyword(activityAccess.leftCurlyBracketKeyword_9)
        val closeActionFlow = activity.regionFor.keyword(activityAccess.rightCurlyBracketKeyword_11)

        openActionFlow.prepend[oneSpace].append[newLine]
        closeActionFlow.prepend[newLine].append[newLine]

        interior(openActionFlow, closeActionFlow)[indent]
        

        activity.regionFor.keyword(activityAccess.actionsKeyword_4).append[oneSpace]

        for (Node node : activity.getNodes()) {
            node.prepend[newLine]
            node?.format
        }

        for (Edge edge : activity.getEdges()) {
            edge.prepend[newLine]
            edge?.format
        }
    }

    def dispatch void format(Claim claim, extension IFormattableDocument document) {
        claim.regionFor.keyword(claimAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        claim.regionFor.keyword(claimAccess.claimKeyword_4).surround[oneSpace]
        claim.regionFor.assignment(claimAccess.resourceAssignment_5).surround[oneSpace]
    }

    def dispatch void format(Release release, extension IFormattableDocument document) {
        release.regionFor.keyword(releaseAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        release.regionFor.keyword(releaseAccess.releaseKeyword_4).surround[oneSpace]
        release.regionFor.assignment(releaseAccess.resourceAssignment_5).surround[oneSpace]
    }

    def dispatch void format(Move move, extension IFormattableDocument document) {
        move.regionFor.keyword(moveAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        move.regionFor.keyword(moveAccess.moveKeyword_4).surround[oneSpace]
        move.regionFor.keyword(moveAccess.passingPassingKeyword_8_0_0_0_0).surround[oneSpace]
        move.regionFor.keyword(moveAccess.continuingContinuingKeyword_8_1_0_0_0).surround[oneSpace]
        move.regionFor.keyword(moveAccess.toKeyword_8_0_0_1).surround[oneSpace]
        move.regionFor.keyword(moveAccess.forKeyword_8_1_0_1).surround[oneSpace]
        move.regionFor.keyword(moveAccess.withSpeedProfileKeyword_9_0).surround[oneSpace]
        move.regionFor.ruleCall(moveAccess.schedulingTypeSchedulingEnumRuleCall_10_0).surround[oneSpace]
        move.regionFor.feature(MOVE__PROFILE).surround[oneSpace]
    }

     def dispatch void format(SimpleAction simpleaction, extension IFormattableDocument document) {
        simpleaction.regionFor.keyword(simpleActionAccess.colonKeyword_2).prepend[noSpace].append[oneSpace]
        simpleaction.regionFor.feature(SIMPLE_ACTION__TYPE).append[oneSpace]
        simpleaction.regionFor.keyword(simpleActionAccess.fullStopKeyword_5_0).surround[noSpace]
        simpleaction.regionFor.keyword(simpleActionAccess.fullStopKeyword_5_2).surround[noSpace]
    }

    def dispatch void format(Edge edge, extension IFormattableDocument document) {
        edge.regionFor.keyword(edgeAccess.hyphenMinusGreaterThanSignKeyword_2).prepend[oneSpace]
        
        edge.source?.format
        edge.target?.format
    }
    
    def dispatch void format(SourceReference sourceRef, extension IFormattableDocument document) {
        sourceRef.regionFor.keyword(sourceReferenceAccess.verticalLineKeyword_1_1_0).prepend[oneSpace].append[noSpace]
        sourceRef.regionFor.ruleCall(sourceReferenceAccess.nodeActionIIDParserRuleCall_1_0_0_1).prepend[oneSpace]
    }
    
    def dispatch void format(TargetReference targetRef, extension IFormattableDocument document) {
        targetRef.regionFor.ruleCall(targetReferenceAccess.nodeActionIIDParserRuleCall_1_0_0_1).prepend[oneSpace]
        targetRef.regionFor.keyword(targetReferenceAccess.verticalLineKeyword_1_1_0).prepend[oneSpace].append[noSpace]
    }
    
}
