/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class SimplifyOthers
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "The \"simplify-others\" CIF to CIF transformation currently does not support CIF specifications with component definitions.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    protected void preprocessAutomaton(Automaton aut) {
        Monitors monitors = aut.getMonitors();
        if (monitors != null) {
            this.removeDuplicateEventRefs((List<Expression>)monitors.getEvents());
        }
    }

    protected void preprocessAlphabet(Alphabet alphabet) {
        this.removeDuplicateEventRefs((List<Expression>)alphabet.getEvents());
    }

    protected void preprocessEdge(Edge edge) {
        Location src = (Location)edge.eContainer();
        Location tgt = edge.getTarget();
        if (tgt != null && src == tgt) {
            edge.setTarget(null);
        }
        List eventRefs = Lists.list();
        for (EdgeEvent edgeEvent : edge.getEvents()) {
            if (edgeEvent instanceof EdgeSend) continue;
            eventRefs.add(edgeEvent.getEvent());
        }
        this.removeDuplicateEventRefs(eventRefs);
    }

    private void removeDuplicateEventRefs(List<Expression> eventRefs) {
        int i = eventRefs.size() - 1;
        while (i >= 0) {
            Expression eventRef = eventRefs.get(i);
            boolean duplicate = false;
            int j = eventRefs.size() - 1;
            while (j > i) {
                if (CifEventUtils.areSameEventRefs((Expression)eventRef, (Expression)eventRefs.get(j), null)) {
                    duplicate = true;
                    break;
                }
                --j;
            }
            if (duplicate) {
                if (eventRefs instanceof EList) {
                    eventRefs.remove(i);
                } else {
                    Assert.check((boolean)(eventRefs instanceof ArrayList));
                    EdgeEvent edgeEvent = (EdgeEvent)eventRef.eContainer();
                    EMFHelper.removeFromParentContainment((EObject)edgeEvent);
                }
            }
            --i;
        }
    }
}

