/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.validation.type.IType;

public class ValidationResult
implements IValidationResult {
    private final Map<Expression, Set<IType>> types = new HashMap<Expression, Set<IType>>();
    private final Map<Expression, Map<Boolean, Map<String, Set<IType>>>> inferredVariableType = new HashMap<Expression, Map<Boolean, Map<String, Set<IType>>>>();
    private final List<IValidationMessage> messages = new ArrayList<IValidationMessage>();
    private final IQueryBuilderEngine.AstResult astResult;

    public ValidationResult(IQueryBuilderEngine.AstResult astResult) {
        this.astResult = astResult;
    }

    public void addTypes(Expression expression, Set<IType> possibleTypes) {
        this.types.put(expression, possibleTypes);
    }

    @Override
    public Set<IType> getPossibleTypes(Expression expression) {
        return this.types.get(expression);
    }

    @Override
    public List<IValidationMessage> getMessages() {
        return this.messages;
    }

    @Override
    public IQueryBuilderEngine.AstResult getAstResult() {
        return this.astResult;
    }

    public void putInferredVariableTypes(Expression expression, Boolean value, Map<String, Set<IType>> inferredTypes) {
        Map<String, Set<IType>> t;
        Map<Boolean, Map<String, Set<IType>>> map = this.inferredVariableType.get(expression);
        if (map == null) {
            map = new HashMap<Boolean, Map<String, Set<IType>>>();
            this.inferredVariableType.put(expression, map);
        }
        if ((t = map.get(value)) == null) {
            t = new HashMap<String, Set<IType>>();
            map.put(value, t);
        }
        t.putAll(inferredTypes);
    }

    @Override
    public Map<String, Set<IType>> getInferredVariableTypes(Expression expression, Boolean value) {
        Map<String, Set<IType>> inferedTypes;
        Map<Boolean, Map<String, Set<IType>>> map = this.inferredVariableType.get(expression);
        Map<String, Set<IType>> result = map != null ? ((inferedTypes = map.get(value)) != null ? inferedTypes : Collections.emptyMap()) : Collections.emptyMap();
        return result;
    }
}

