/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.java.Strings;

public class JarClassLoader
extends URLClassLoader {
    private final String jarPath;
    private final URL jarUrl;
    private final JarURLConnection jarUrlConnection;

    public JarClassLoader(String jarPath, ClassLoader parent) {
        super(new URL[]{JarClassLoader.constructJarUrl(jarPath)}, parent);
        this.jarPath = jarPath;
        this.jarUrl = JarClassLoader.constructJarUrl(jarPath);
        this.jarUrlConnection = this.initializeConnection();
    }

    private static URL constructJarUrl(String jarPath) {
        URL url;
        URI uri = Paths.createJavaURI(jarPath);
        try {
            url = new URL("jar", "", String.valueOf(uri.toString()) + "!/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid JAR file path: " + jarPath, e);
        }
        return url;
    }

    private JarURLConnection initializeConnection() {
        JarURLConnection jarConnection;
        try {
            jarConnection = (JarURLConnection)this.jarUrl.openConnection();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Could not open URL \"%s\".", (Object[])new Object[]{this.jarUrl});
            throw new InputOutputException(msg, e);
        }
        jarConnection.setDefaultUseCaches(false);
        jarConnection.setUseCaches(false);
        return jarConnection;
    }

    public String getMainClassName() {
        Attributes attrs;
        try {
            attrs = this.jarUrlConnection.getMainAttributes();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Could not retrieve main class name for JAR file \"%s\".", (Object[])new Object[]{this.jarPath});
            throw new InputOutputException(msg, e);
        }
        if (attrs == null) {
            String msg = Strings.fmt((String)"Could not retrieve main class name for JAR file \"%s\".", (Object[])new Object[]{this.jarPath});
            throw new InputOutputException(msg);
        }
        String mainClass = attrs.getValue(Attributes.Name.MAIN_CLASS);
        if (mainClass == null || mainClass.isEmpty()) {
            String msg = Strings.fmt((String)"The main class name in the manifest of JAR file \"%s\" is not valid.", (Object[])new Object[]{this.jarPath});
            throw new InputOutputException(msg);
        }
        return mainClass;
    }

    public <T> Class<? extends T> loadClassByName(String absClassName) {
        try {
            Class<?> rslt = this.loadClass(absClassName, true);
            return rslt;
        }
        catch (ClassNotFoundException e) {
            String msg = Strings.fmt((String)"Could not find class \"%s\" in JAR file \"%s\".", (Object[])new Object[]{absClassName, this.jarPath});
            throw new InputOutputException(msg, e);
        }
    }
}

