/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.io;

import java.io.PrintStream;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Strings;

public class StdAppStream
extends AppStream {
    public static final AppStream OUT = new StdAppStream(System.out, true);
    public static final AppStream ERR = new StdAppStream(System.err, false);
    private final PrintStream stream;
    private final boolean stdout;

    public StdAppStream(PrintStream stream, boolean stdout) {
        this.stream = stream;
        this.stdout = stdout;
    }

    @Override
    protected void writeImpl(byte b) {
        this.stream.write(b);
        if (this.stream.checkError()) {
            String msg = Strings.fmt((String)"Failed to write to %s.", (Object[])new Object[]{this.getStreamName()});
            throw new InputOutputException(msg);
        }
    }

    @Override
    protected void writeImpl(byte[] bytes, int offset, int length) {
        this.stream.write(bytes, offset, length);
        if (this.stream.checkError()) {
            String msg = Strings.fmt((String)"Failed to write to %s.", (Object[])new Object[]{this.getStreamName()});
            throw new InputOutputException(msg);
        }
    }

    @Override
    protected void flushImpl() {
        this.stream.flush();
        if (this.stream.checkError()) {
            String msg = Strings.fmt((String)"Failed to write to %s.", (Object[])new Object[]{this.getStreamName()});
            throw new InputOutputException(msg);
        }
    }

    @Override
    protected void closeImpl() {
        this.stream.close();
        if (this.stream.checkError()) {
            String msg = Strings.fmt((String)"Failed to write to %s.", (Object[])new Object[]{this.getStreamName()});
            throw new InputOutputException(msg);
        }
    }

    private String getStreamName() {
        return this.stdout ? "stdout" : "stderr";
    }
}

