/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.options;

import org.eclipse.escet.cif.common.CifValidationUtils;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.StringOption;
import org.eclipse.escet.common.java.Strings;

public class CodePrefixOption
extends StringOption {
    public CodePrefixOption() {
        super("Code prefix", "The code prefix, used to prefix file names, identifiers in the code, etc. If no prefix is given, the prefix is derived from the input filename, by removing the \".cif\" file extension, if present. This is also the default. The prefix must be a valid CIF identifier.", Character.valueOf('p'), "code-prefix", "PREFIX", null, true, true, "The code prefix, used to prefix file names, identifiers in the code, etc. If no prefix is given, the prefix is derived from the input filename, by removing the \".cif\" file extension, if present. The prefix must be a valid CIF identifier.", "Prefix:");
    }

    public static String getPrefix() {
        String prefix = (String)Options.get(CodePrefixOption.class);
        if (prefix == null) {
            prefix = InputFileOption.getPath();
            prefix = Paths.getFileName((String)prefix);
            if (!CifValidationUtils.isValidIdentifier((String)(prefix = Paths.pathChangeExtension((String)prefix, (String)"cif", null)))) {
                String msg = Strings.fmt((String)"Code prefix \"%s\" derived from the input filename of the CIF code generator is not a valid CIF identifier. Please provide a custom code prefix using the appropriate option.", (Object[])new Object[]{prefix});
                throw new InvalidOptionException(msg);
            }
            return prefix;
        }
        if (!CifValidationUtils.isValidIdentifier((String)prefix)) {
            String msg = Strings.fmt((String)"Code prefix \"%s\" specified using the code prefix option of the CIF code generator is not a valid CIF identifier.", (Object[])new Object[]{prefix});
            throw new InvalidOptionException(msg);
        }
        return prefix;
    }
}

