/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89.typeinfos;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprProperties;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.IntTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class C89IntTypeInfo
extends IntTypeInfo
implements C89TypeInfo {
    public final boolean genLocalFunctions;

    public C89IntTypeInfo(boolean genLocalFunctions, CifType cifType) {
        super(cifType);
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return true;
    }

    @Override
    public boolean useValues() {
        return true;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return "IntTypePrint";
    }

    @Override
    public ExprCode convertLiteral(String value, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(C89DataValue.makeLiteral(value));
        return result;
    }

    @Override
    protected ExprCode convertAddition(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) + (${right-value})" : "IntegerAdd(${left-value}, ${right-value})";
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertSubtraction(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) - (${right-value})" : "IntegerSubtract(${left-value}, ${right-value})";
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertMultiplication(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) * (${right-value})" : "IntegerMultiply(${left-value}, ${right-value})";
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertDiv(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) / (${right-value})" : "IntegerDiv(${left-value}, ${right-value})";
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertMod(BinaryExpression expr, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        String pattern = properties.isEmpty() ? "(${left-value}) % (${right-value})" : "IntegerMod(${left-value}, ${right-value})";
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, pattern, dest, ctxt);
    }

    @Override
    protected ExprCode convertIntNegate(Expression child, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(child, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.setDestination(dest);
        if (properties.isEmpty()) {
            result.setDataValue(C89DataValue.makeComputed(Strings.fmt((String)"-(%s)", (Object[])new Object[]{childCode.getData()})));
        } else {
            result.setDataValue(C89DataValue.makeComputed(Strings.fmt((String)"IntegerNegate(%s)", (Object[])new Object[]{childCode.getData()})));
        }
        return result;
    }

    @Override
    protected ExprCode convertAbsStdLib(Expression expression, EnumSet<ExprProperties> properties, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("IntegerAbs(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertMaximumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("IntegerMax(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertMinimumStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("IntegerMin(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertSignStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("IntegerSign(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertPowerStdLib(List<Expression> exprs, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("IntegerPower(${args})", exprs, dest, ctxt);
    }

    @Override
    public ExprCode convertCeilStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("CeilFunction(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertFloorStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("FloorFunction(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public ExprCode convertRoundStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern("RoundFunction(${args})", Lists.list((Object)expression), dest, ctxt);
    }

    @Override
    public String getTargetType() {
        return "IntType";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "(${left-value}) == (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "(${left-value}) != (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_THAN)) {
            return "(${left-value}) < (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.LESS_EQUAL)) {
            return "(${left-value}) <= (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_THAN)) {
            return "(${left-value}) > (${right-value})";
        }
        if (binOp.equals((Object)BinaryOperator.GREATER_EQUAL)) {
            return "(${left-value}) >= (${right-value})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof C89IntTypeInfo;
    }

    @Override
    public int hashCode() {
        return C89IntTypeInfo.class.hashCode();
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        IntType lhsInt = (IntType)lhsType;
        IntType rhsInt = (IntType)rhsType;
        int lhsLower = CifTypeUtils.getLowerBound((IntType)lhsInt);
        int rhsLower = CifTypeUtils.getLowerBound((IntType)rhsInt);
        String guard1 = null;
        if (rhsLower < lhsLower) {
            guard1 = Strings.fmt((String)"(%s) < %s", (Object[])new Object[]{rhsValue.getData(), lhsLower});
        }
        int lhsUpper = CifTypeUtils.getUpperBound((IntType)lhsInt);
        int rhsUpper = CifTypeUtils.getUpperBound((IntType)rhsInt);
        String guard2 = null;
        if (rhsUpper > lhsUpper) {
            guard2 = Strings.fmt((String)"(%s) > %s", (Object[])new Object[]{rhsValue.getData(), lhsUpper});
        }
        if (guard1 != null) {
            if (guard2 != null) {
                guard1 = Strings.fmt((String)"%s || %s", (Object[])new Object[]{guard1, guard2});
            }
        } else {
            if (guard2 == null) {
                return;
            }
            guard1 = guard2;
        }
        String indexedVarName = Strings.stringToJava((String)varName);
        List arguments = Lists.list();
        if (!errorTexts.isEmpty()) {
            String indices = "\"";
            for (RangeCheckErrorLevelText errText : errorTexts) {
                if (errText.isIntVariable) {
                    indices = String.valueOf(indices) + "[%d]";
                    arguments.add(errText.text);
                    continue;
                }
                indices = String.valueOf(indices) + "[" + errText.text + "]";
            }
            indices = String.valueOf(indices) + "\"";
            indexedVarName = String.valueOf(indexedVarName) + " " + indices;
        }
        code.add("if (%s) {", new Object[]{guard1});
        code.indent();
        code.add("fprintf(stderr, \"RangeError: Writing %%d into \\\"%s\\\"\\n\", %s);", new Object[]{Strings.escape((String)CifTextUtils.typeToStr((CifType)varType)), rhsValue.getData()});
        if (arguments.isEmpty()) {
            code.add("fprintf(stderr, \"            at \" %s \"\\n\");", new Object[]{indexedVarName});
        } else {
            code.add("fprintf(stderr, \"            at \" %s \"\\n\", %s);", new Object[]{indexedVarName, StringUtils.join((Collection)arguments, (String)", ")});
        }
        code.add("RangeErrorDetected();");
        code.dedent();
        code.add("}");
    }
}

