/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceSetUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractEMFMultiPageEditorPart
extends MultiPageEditorPart
implements IEditingDomainProvider,
IViewerProvider,
IMenuListener {
    private final Map<Control, ViewerPane> viewerMap = new WeakHashMap<Control, ViewerPane>();
    protected EditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage = null;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected boolean updateProblemIndication = true;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == AbstractEMFMultiPageEditorPart.this.contentOutlinePage) {
                    AbstractEMFMultiPageEditorPart.this.getActionBarContributor().setActiveEditor((IEditorPart)AbstractEMFMultiPageEditorPart.this);
                }
            } else if (p == AbstractEMFMultiPageEditorPart.this) {
                AbstractEMFMultiPageEditorPart.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = AbstractEMFMultiPageEditorPart.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            AbstractEMFMultiPageEditorPart.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            AbstractEMFMultiPageEditorPart.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!AbstractEMFMultiPageEditorPart.this.updateProblemIndication) return;
                        AbstractEMFMultiPageEditorPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AbstractEMFMultiPageEditorPart.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            AbstractEMFMultiPageEditorPart.this.resourceToDiagnosticMap.remove(target);
            if (AbstractEMFMultiPageEditorPart.this.updateProblemIndication) {
                AbstractEMFMultiPageEditorPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEMFMultiPageEditorPart.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).AbstractEMFMultiPageEditorPart.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!(this).AbstractEMFMultiPageEditorPart.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    AbstractEMFMultiPageEditorPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).AbstractEMFMultiPageEditorPart.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!AbstractEMFMultiPageEditorPart.this.isDirty()) {
                                AbstractEMFMultiPageEditorPart.this.getSite().getPage().closeEditor((IEditorPart)AbstractEMFMultiPageEditorPart.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    AbstractEMFMultiPageEditorPart.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).AbstractEMFMultiPageEditorPart.this.changedResources.addAll(visitor.getChangedResources());
                            if (AbstractEMFMultiPageEditorPart.this.getSite().getPage().getActiveEditor() == AbstractEMFMultiPageEditorPart.this) {
                                AbstractEMFMultiPageEditorPart.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                AbstractEMFMultiPageEditorPart.this.getPlugin().log((Object)exception);
            }
        }
    };

    protected void handleActivate() {
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
                this.handleReload();
            }
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleReload() {
        this.updateProblemIndication = false;
        ArrayList resourcesToReload = new ArrayList(this.editingDomain.getResourceSet().getResources());
        Iterator i = resourcesToReload.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (resource.isLoaded()) {
                resource.unload();
                continue;
            }
            i.remove();
        }
        for (Resource resource : resourcesToReload) {
            try {
                resource.load(this.editingDomain.getResourceSet().getLoadOptions());
            }
            catch (IOException exception) {
                if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
            }
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
        this.editingDomain.getCommandStack().flush();
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, this.getPlugin().getSymbolicName(), 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    this.getPlugin().log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        this.getPlugin().log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Conflict", (String)"There are unsaved changes that conflict with changes made outside the editor.  Do you wish to discard this editor's changes?");
    }

    public AbstractEMFMultiPageEditorPart() {
        this.initializeEditingDomain();
    }

    protected abstract EMFPlugin getPlugin();

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                AbstractEMFMultiPageEditorPart.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEMFMultiPageEditorPart.this.firePropertyChange(257);
                    }
                });
            }
        });
        this.editingDomain = this.createEditingDomain((CommandStack)commandStack, new HashMap<Resource, Boolean>());
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    protected EditingDomain createEditingDomain(CommandStack commandStack, Map<Resource, Boolean> resourceToReadOnlyMap) {
        return new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, commandStack, resourceToReadOnlyMap);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected Resource createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput(), (URIConverter)this.editingDomain.getResourceSet().getURIConverter());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        }
        return resource;
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, this.getPlugin().getSymbolicName(), 0, String.format("Problems encountered in file \"%s\"", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, this.getPlugin().getSymbolicName(), 0, String.format("Problems encountered in file \"%s\"", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected String getString(String key, Object ... substitutions) {
        return this.getPlugin().getString(key, substitutions);
    }

    protected void showTabs() {
        if (this.getPageCount() > 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(-1);
            Point point = this.getContainer().getSize();
            this.getContainer().setSize(point.x, point.y - 6);
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                for (Resource resource : ResourceSetUtil.getResourcesInSaveOrder((ResourceSet)AbstractEMFMultiPageEditorPart.this.editingDomain.getResourceSet())) {
                    if (AbstractEMFMultiPageEditorPart.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() == timeStamp) continue;
                        AbstractEMFMultiPageEditorPart.this.savedResources.add(resource);
                    }
                    catch (Exception exception) {
                        AbstractEMFMultiPageEditorPart.this.resourceToDiagnosticMap.put(resource, AbstractEMFMultiPageEditorPart.this.analyzeResourceProblems(resource, exception));
                    }
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            this.getPlugin().log((Object)exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            if (this.contentOutlinePage == null) {
                this.contentOutlinePage = this.createOutlinePage();
            }
            return (T)this.contentOutlinePage;
        }
        return (T)super.getAdapter(adapter);
    }

    protected IContentOutlinePage createOutlinePage() {
        return null;
    }

    @Deprecated
    public final int addPage(Control control) {
        throw new UnsupportedOperationException("Please use addPage(ViewerPane viewerPane)");
    }

    @Deprecated
    public final void addPage(int index, Control control) {
        throw new UnsupportedOperationException("Please use addPage(int index, ViewerPane viewerPane)");
    }

    public final int addPage(ViewerPane viewerPane) {
        int index = this.getPageCount();
        this.addPage(index, viewerPane);
        return index;
    }

    public final void addPage(int index, ViewerPane viewerPane) {
        Control pageControl = viewerPane.getControl();
        this.viewerMap.put(pageControl, viewerPane);
        super.addPage(index, pageControl);
    }

    public void removePage(int pageIndex) {
        this.viewerMap.remove(this.getControl(pageIndex));
        super.removePage(pageIndex);
    }

    public Viewer getViewer() {
        return this.getViewer(this.getSelectedPage());
    }

    protected Viewer getViewer(Object page) {
        ViewerPane viewerPane = this.viewerMap.get(page);
        return viewerPane == null ? null : viewerPane.getViewer();
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        IEditorActionBarContributor actionBarContributor = this.getEditorSite().getActionBarContributor();
        if (actionBarContributor instanceof IMenuListener) {
            ((IMenuListener)actionBarContributor).menuAboutToShow(menuManager);
        }
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }
}

