/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.List;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;

public class ExprCode {
    private static final CodeBox EMPTY_CODE = new MemoryCodeBox();
    private CodeBox code = null;
    private boolean codeRetrieved = false;
    private Destination destination = null;
    private DataValue value = null;

    private void prepareAddCode() {
        Assert.check((!this.codeRetrieved ? 1 : 0) != 0);
        if (this.code == null) {
            this.code = new MemoryCodeBox();
        }
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public void add() {
        this.prepareAddCode();
        this.code.add();
    }

    public void add(String line) {
        this.prepareAddCode();
        this.code.add(line);
    }

    public void add(String line, Object[] args) {
        this.prepareAddCode();
        this.code.add(line, args);
    }

    public void add(List<String> lines) {
        this.prepareAddCode();
        this.code.add(lines);
    }

    public void add(String[] lines) {
        this.prepareAddCode();
        this.code.add(lines);
    }

    public void add(CodeBox box) {
        this.prepareAddCode();
        this.code.add((Box)box);
    }

    public void add(ExprCode exprCode) {
        this.prepareAddCode();
        CodeBox rawCode = exprCode.getRawCode();
        if (rawCode != null && !rawCode.isEmpty()) {
            this.code.add((Box)rawCode);
        }
    }

    public CodeBox getRawCode() {
        Assert.check((!this.codeRetrieved ? 1 : 0) != 0);
        if (this.destination != null) {
            Assert.check((this.value != null ? 1 : 0) != 0);
            if (this.code == null) {
                this.prepareAddCode();
            }
            this.destination.getTypeInfo().storeValue(this.code, this.value, this.destination);
            this.destination = null;
            this.value = null;
        }
        this.codeRetrieved = true;
        return this.code;
    }

    public CodeBox getCode() {
        CodeBox rawCode = this.getRawCode();
        return rawCode == null ? EMPTY_CODE : rawCode;
    }

    public void setDestination(Destination dest) {
        Assert.check((!this.codeRetrieved ? 1 : 0) != 0);
        this.destination = dest;
    }

    public void setDataValue(DataValue value) {
        Assert.check((this.value == null ? 1 : 0) != 0);
        this.value = value;
    }

    public boolean hasDataValue() {
        return this.destination == null && this.value != null;
    }

    public DataValue getRawDataValue() {
        Assert.check((this.codeRetrieved || this.code == null || this.code.isEmpty() ? 1 : 0) != 0);
        Assert.check((this.destination == null && this.value != null ? 1 : 0) != 0);
        DataValue retValue = this.value;
        this.value = null;
        return retValue;
    }

    public String getData() {
        return this.getRawDataValue().getData();
    }

    public String getReference() {
        return this.getRawDataValue().getReference();
    }
}

