/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.comments.AggregatedHeuristicsAttachmentDecider;
import org.eclipse.elk.core.comments.IAttachmentDecider;
import org.eclipse.elk.core.comments.IAttachmentTargetProvider;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IEligibilityFilter;
import org.eclipse.elk.core.comments.IExplicitAttachmentProvider;
import org.eclipse.elk.core.comments.IHeuristic;
import org.eclipse.elk.core.comments.ShapeLayoutBoundsProvider;
import org.eclipse.elk.core.comments.SiblingAttachmentTargetProvider;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public final class CommentAttacher {
    private boolean includeHierarchy = true;
    private boolean explicitAttachmentsDisableHeuristics = true;
    private IExplicitAttachmentProvider explicitAttachmentProvider = a -> null;
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private IAttachmentTargetProvider targetProvider = new SiblingAttachmentTargetProvider();
    private List<IEligibilityFilter> eligibilityFilters = Lists.newArrayList();
    private List<IHeuristic> heuristics = Lists.newArrayList();
    private IAttachmentDecider attachmentDecider = new AggregatedHeuristicsAttachmentDecider();

    public CommentAttacher limitToCurrentHierarchyLevel() {
        this.includeHierarchy = false;
        return this;
    }

    public CommentAttacher keepHeuristicsEnabledWithExplicitAttachments() {
        this.explicitAttachmentsDisableHeuristics = false;
        return this;
    }

    public CommentAttacher withExplicitAttachmentProvider(IExplicitAttachmentProvider provider) {
        this.explicitAttachmentProvider = provider == null ? a -> null : provider;
        return this;
    }

    public CommentAttacher withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    public CommentAttacher withAttachmentTargetProvider(IAttachmentTargetProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The attachment target provider must not be null.");
        }
        this.targetProvider = provider;
        return this;
    }

    public CommentAttacher addEligibilityFilter(IEligibilityFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The eligibility filter must not be null.");
        }
        this.eligibilityFilters.add(filter);
        return this;
    }

    public CommentAttacher addHeuristic(IHeuristic heuristic) {
        if (heuristic == null) {
            throw new IllegalArgumentException("The attachment heuristic must not be null.");
        }
        this.heuristics.add(heuristic);
        return this;
    }

    public CommentAttacher withAttachmentDecider(IAttachmentDecider decider) {
        if (decider == null) {
            throw new IllegalArgumentException("The attachment target provider must not be null.");
        }
        this.attachmentDecider = decider;
        return this;
    }

    public Collection<ElkEdge> attachComments(ElkNode graph) {
        this.preprocess(graph);
        ArrayList explicitAttachments = Lists.newArrayList();
        ArrayList heuristicAttachments = Lists.newArrayList();
        LinkedList processingQueue = Lists.newLinkedList((Iterable)graph.getChildren());
        while (!processingQueue.isEmpty()) {
            ElkNode node = (ElkNode)processingQueue.poll();
            if (CommentAttacher.isComment(node)) {
                ElkGraphElement heuristicAttachment;
                ElkGraphElement explicitAttachment = this.explicitAttachmentProvider.findExplicitAttachment(node);
                if (explicitAttachment != null) {
                    explicitAttachments.add(Pair.of(node, explicitAttachment));
                } else if ((explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) && this.isEligibleForHeuristicAttachment(node) && (heuristicAttachment = this.findHeuristicAttachment(node)) != null) {
                    heuristicAttachments.add(Pair.of(node, heuristicAttachment));
                }
            }
            if (!this.includeHierarchy) continue;
            processingQueue.addAll(node.getChildren());
        }
        this.cleanup();
        Collection<ElkEdge> createdEdges = this.edgeifyFoundAttachments(explicitAttachments, heuristicAttachments);
        return createdEdges;
    }

    private void preprocess(ElkNode graph) {
        this.explicitAttachmentProvider.preprocess(graph, this.includeHierarchy);
        this.boundsProvider.preprocess(graph, this.includeHierarchy);
        this.targetProvider.preprocess(graph, this.includeHierarchy);
        this.eligibilityFilters.stream().forEach(f -> f.preprocess(graph, this.includeHierarchy));
        this.heuristics.stream().forEach(h -> h.preprocess(graph, this.includeHierarchy));
    }

    private boolean isEligibleForHeuristicAttachment(ElkNode comment) {
        return this.eligibilityFilters.stream().allMatch(f -> f.eligibleForAttachment(comment));
    }

    private ElkGraphElement findHeuristicAttachment(ElkNode comment) {
        if (this.heuristics.isEmpty()) {
            return null;
        }
        List<ElkGraphElement> candidates = this.targetProvider.provideAttachmentTargetsFor(comment);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        HashMap results = Maps.newHashMap();
        for (ElkGraphElement candidate : candidates) {
            HashMap candidateResults = Maps.newHashMap();
            results.put(candidate, candidateResults);
            for (IHeuristic heuristic : this.heuristics) {
                candidateResults.put(heuristic.getClass(), heuristic.normalized(comment, candidate));
            }
        }
        return this.attachmentDecider.makeAttachmentDecision(results);
    }

    private Collection<ElkEdge> edgeifyFoundAttachments(Collection<Pair<ElkNode, ElkGraphElement>> explicitAttachments, Collection<Pair<ElkNode, ElkGraphElement>> heuristicAttachments) {
        ArrayList createdEdges = Lists.newArrayListWithCapacity((int)(explicitAttachments.size() + heuristicAttachments.size()));
        createdEdges.addAll(this.edgeifyFoundAttachments(explicitAttachments));
        if (explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) {
            createdEdges.addAll(this.edgeifyFoundAttachments(heuristicAttachments));
        }
        return createdEdges;
    }

    private Collection<ElkEdge> edgeifyFoundAttachments(Collection<Pair<ElkNode, ElkGraphElement>> attachments) {
        ArrayList createdEdges = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Pair<ElkNode, ElkGraphElement> attachment : attachments) {
            if (!(attachment.getSecond() instanceof ElkNode)) continue;
            ElkNode comment = attachment.getFirst();
            ElkNode target = (ElkNode)attachment.getSecond();
            ElkEdge edge = ElkGraphUtil.createEdge((ElkNode)comment.getParent());
            edge.getSources().add((Object)comment);
            edge.getTargets().add((Object)target);
            createdEdges.add(edge);
        }
        return createdEdges;
    }

    private void cleanup() {
        this.explicitAttachmentProvider.cleanup();
        this.boundsProvider.cleanup();
        this.targetProvider.cleanup();
        this.eligibilityFilters.stream().forEach(f -> f.cleanup());
        this.heuristics.stream().forEach(h -> h.cleanup());
    }

    public static boolean isComment(ElkNode node) {
        return (Boolean)node.getProperty(CoreOptions.COMMENT_BOX);
    }
}

