/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractSequenceInteractionValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.RangeGuide;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.draw2d.figure.HorizontalGuide;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.swt.graphics.Color;

public class SequenceInteractionFeedBackBuilder {
    private static final Color ISE_FEEDBACK_COLOR = ColorConstants.lightGray;
    private final AbstractSequenceInteractionValidator validator;
    private final IFigure feedBackLayer;
    private final IGraphicalEditPart hostPart;

    public SequenceInteractionFeedBackBuilder(AbstractSequenceInteractionValidator validator, IFigure feedBackLayer, IGraphicalEditPart hostPart) {
        this.validator = validator;
        this.feedBackLayer = feedBackLayer;
        this.hostPart = hostPart;
    }

    public Collection<Figure> buildFeedBack() {
        ArrayList<Figure> feedbacks = new ArrayList<Figure>();
        this.validator.validate();
        this.feedBackCreatedElements(feedbacks);
        this.feedBackMovedElements(feedbacks);
        this.feedBackResizedElements(feedbacks);
        this.feedBackExpansion(feedbacks);
        this.feedBackErrors(feedbacks);
        this.feedBackConflicts(feedbacks);
        return feedbacks;
    }

    private void feedBackConflicts(Collection<Figure> feedbacks) {
        for (Integer n : this.validator.getInvalidPostions()) {
            Point conflictingPosition = new Point(0, n.intValue());
            conflictingPosition.performScale(GraphicalHelper.getZoom((EditPart)this.hostPart));
            Rectangle bounds = this.feedBackLayer.getBounds().getCopy();
            bounds.y = conflictingPosition.y;
            bounds.height = 1;
            HorizontalGuide conflictGuide = new HorizontalGuide(ColorConstants.red, conflictingPosition.y);
            conflictGuide.setBounds(bounds);
            feedbacks.add((Figure)conflictGuide);
        }
        for (Range range : this.validator.getInvalidRanges()) {
            Rectangle screenRange = new Rectangle(0, range.getLowerBound(), 0, range.width());
            screenRange.performScale(GraphicalHelper.getZoom((EditPart)this.hostPart));
            Range conflictRange = RangeHelper.verticalRange((Rectangle)screenRange);
            Rectangle bounds = this.feedBackLayer.getBounds().getCopy();
            bounds.y = conflictRange.getLowerBound();
            bounds.height = Math.max(1, conflictRange.width());
            RangeGuide guide = new RangeGuide(ColorConstants.red, conflictRange, true);
            guide.setBounds(bounds);
            feedbacks.add(guide);
        }
    }

    private void feedBackErrors(Collection<Figure> feedbacks) {
        for (ISequenceEvent errorEvent : this.validator.getEventsInError()) {
            this.addFeedBack(errorEvent, ColorConstants.red, true, feedbacks, (Range)this.validator.getRangeFunction().apply((Object)errorEvent));
        }
    }

    private void addFeedBack(ISequenceEvent event, Color color, boolean fill, Collection<Figure> feedbacks, Range movedRange) {
        Rectangle screenRange = new Rectangle(0, movedRange.getLowerBound(), 0, movedRange.width());
        screenRange.performScale(GraphicalHelper.getZoom((EditPart)this.hostPart));
        Range moveRange = RangeHelper.verticalRange((Rectangle)screenRange);
        Rectangle bounds = this.feedBackLayer.getBounds().getCopy();
        if (event != null && event.isLogicallyInstantaneous()) {
            moveRange = new Range(screenRange.getCenter().y, screenRange.getCenter().y);
            bounds.y = moveRange.getLowerBound();
            bounds.height = 1;
        } else {
            bounds.y = moveRange.getLowerBound();
            bounds.height = Math.max(1, moveRange.width());
        }
        RangeGuide guide = new RangeGuide(color, moveRange, fill);
        guide.setBounds(bounds);
        feedbacks.add(guide);
    }

    private void feedBackExpansion(Collection<Figure> feedbacks) {
        Rectangle bounds = this.feedBackLayer.getBounds().getCopy();
        Range expansionZone = this.validator.getExpansionZone();
        if (expansionZone != null && !expansionZone.isEmpty() && expansionZone.width() != 0) {
            Rectangle screenRange = new Rectangle(0, expansionZone.getLowerBound(), 0, expansionZone.width());
            screenRange.performScale(GraphicalHelper.getZoom((EditPart)this.hostPart));
            Range expand = RangeHelper.verticalRange((Rectangle)screenRange);
            RangeGuide expansion = new RangeGuide(this.validator.isValid() ? ColorConstants.blue : ColorConstants.red, expand, true);
            bounds.height = expand.width();
            bounds.y = expand.getLowerBound();
            expansion.setBounds(bounds);
            feedbacks.add(expansion);
        }
    }

    private void feedBackMovedElements(Collection<Figure> feedbacks) {
        for (ISequenceEvent movedElement : Iterables.filter(this.validator.getMovedElements(), (Predicate)Predicates.not((Predicate)Predicates.in(this.validator.getEventsInError())))) {
            this.addFeedBack(movedElement, ISE_FEEDBACK_COLOR, false, feedbacks, (Range)this.validator.getRangeFunction().apply((Object)movedElement));
        }
    }

    private void feedBackCreatedElements(Collection<Figure> feedbacks) {
        for (Range creationRange : this.validator.getCreatedElements()) {
            this.addFeedBack(null, this.validator.isValid() ? ISE_FEEDBACK_COLOR : ColorConstants.red, false, feedbacks, creationRange);
        }
    }

    private void feedBackResizedElements(Collection<Figure> feedbacks) {
        for (ISequenceEvent movedElement : Iterables.filter(this.validator.getResizedStartMessages(), (Predicate)Predicates.not((Predicate)Predicates.in(this.validator.getEventsInError())))) {
            this.addFeedBack(movedElement, ISE_FEEDBACK_COLOR, false, feedbacks, (Range)this.validator.getRangeFunction().apply((Object)movedElement));
        }
        for (ISequenceEvent movedElement : Iterables.filter(this.validator.getResizedEndMessages(), (Predicate)Predicates.not((Predicate)Predicates.in(this.validator.getEventsInError())))) {
            Range feedbackRange = (Range)this.validator.getRangeFunction().apply((Object)movedElement);
            Range expansionZone = this.validator.getExpansionZone();
            if (expansionZone != null && !expansionZone.isEmpty() && feedbackRange.includes(expansionZone.getUpperBound())) {
                feedbackRange = new Range(feedbackRange.getLowerBound(), feedbackRange.getUpperBound() - expansionZone.width());
            }
            this.addFeedBack(movedElement, ISE_FEEDBACK_COLOR, false, feedbacks, feedbackRange);
        }
    }
}

