/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.datasynth.options.SynthesisStatistics;
import org.eclipse.escet.cif.datasynth.options.SynthesisStatisticsOption;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Stopwatch;
import org.eclipse.escet.common.java.Strings;

public class CifDataSynthesisTiming {
    public Stopwatch total = new Stopwatch();
    public Stopwatch inputRead = new Stopwatch();
    public Stopwatch inputPreProcess = new Stopwatch();
    public Stopwatch inputConvert = new Stopwatch();
    public Stopwatch preSynth = new Stopwatch();
    public Stopwatch main = new Stopwatch();
    public Stopwatch mainBwMarked = new Stopwatch();
    public Stopwatch mainBwBadState = new Stopwatch();
    public Stopwatch mainFwInit = new Stopwatch();
    public Stopwatch postSynth = new Stopwatch();
    public Stopwatch outputConvert = new Stopwatch();
    public Stopwatch outputWrite = new Stopwatch();

    public void print(AppEnvData env) {
        EnumSet<SynthesisStatistics> stats = SynthesisStatisticsOption.getStatistics();
        Assert.check((boolean)stats.contains((Object)SynthesisStatistics.TIMING));
        List prefixes = Lists.list();
        List stopwatches = Lists.list();
        if (this.total.hasMeasured()) {
            prefixes.add("Total");
            stopwatches.add(this.total);
        }
        if (this.inputRead.hasMeasured()) {
            prefixes.add("  Read input model");
            stopwatches.add(this.inputRead);
        }
        if (this.inputPreProcess.hasMeasured()) {
            prefixes.add("  Preprocess input model");
            stopwatches.add(this.inputPreProcess);
        }
        if (this.inputConvert.hasMeasured()) {
            prefixes.add("  Convert input model");
            stopwatches.add(this.inputConvert);
        }
        if (this.preSynth.hasMeasured()) {
            prefixes.add("  Pre synthesis");
            stopwatches.add(this.preSynth);
        }
        if (this.main.hasMeasured()) {
            prefixes.add("  Main synthesis loop");
            stopwatches.add(this.main);
        }
        if (this.mainBwMarked.hasMeasured()) {
            prefixes.add("    Backward marking");
            stopwatches.add(this.mainBwMarked);
        }
        if (this.mainBwBadState.hasMeasured()) {
            prefixes.add("    Backward bad-state");
            stopwatches.add(this.mainBwBadState);
        }
        if (this.mainFwInit.hasMeasured()) {
            prefixes.add("    Forward initial");
            stopwatches.add(this.mainFwInit);
        }
        if (this.postSynth.hasMeasured()) {
            prefixes.add("  Post synthesis");
            stopwatches.add(this.postSynth);
        }
        if (this.outputConvert.hasMeasured()) {
            prefixes.add("  Convert output model");
            stopwatches.add(this.outputConvert);
        }
        if (this.outputWrite.hasMeasured()) {
            prefixes.add("  Write output model");
            stopwatches.add(this.outputWrite);
        }
        Assert.check((prefixes.size() == stopwatches.size() ? 1 : 0) != 0);
        String[] measurements = new String[stopwatches.size()];
        int i = 0;
        while (i < stopwatches.size()) {
            Assert.check((!((Stopwatch)stopwatches.get(i)).isRunning() ? 1 : 0) != 0);
            measurements[i] = Strings.fmt((String)"%,.0f ms", (Object[])new Object[]{((Stopwatch)stopwatches.get(i)).getDurationMillis()});
            ++i;
        }
        GridBox grid = new GridBox(measurements.length + 2, 2, 0, 2);
        grid.set(0, 0, "Timing measurement");
        grid.set(0, 1, "Duration");
        int i2 = 0;
        while (i2 < prefixes.size()) {
            grid.set(i2 + 2, 0, (String)prefixes.get(i2));
            grid.set(i2 + 2, 1, measurements[i2]);
            ++i2;
        }
        GridBox.GridBoxLayout layout = grid.computeLayout();
        int i3 = 0;
        while (i3 < layout.numCols) {
            String bar = Strings.duplicate((String)"-", (int)layout.widths[i3]);
            grid.set(1, i3, bar);
            ++i3;
        }
        int timingColWidth = layout.widths[1];
        int i4 = 0;
        while (i4 < measurements.length) {
            String txt = measurements[i4];
            String empty = Strings.spaces((int)(timingColWidth - txt.length()));
            grid.set(i4 + 2, 1, String.valueOf(empty) + txt);
            ++i4;
        }
        OutputProvider.dbg();
        for (String line : grid.getLines()) {
            OutputProvider.out((String)line);
        }
    }
}

