/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.descriptions.JvmTypesResourceDescriptionStrategy;
import org.eclipse.xtext.java.resource.JavaResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaResourceDescriptionManager
implements IResourceDescription.Manager {
    @Inject
    private JvmTypesResourceDescriptionStrategy descriptionStrategy;
    @Inject
    private IResourceScopeCache cache;

    public IResourceDescription.Delta createDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new DefaultResourceDescriptionDelta(oldDescription, newDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResourceDescription getResourceDescription(Resource resource) {
        if (resource instanceof JavaResource) {
            JavaResource javaResource = (JavaResource)resource;
            boolean initialized = javaResource.isInitialized() || javaResource.isInitializing();
            try {
                if (!initialized) {
                    javaResource.eSetDeliver(false);
                    javaResource.installStubs();
                }
                DefaultResourceDescription result = new DefaultResourceDescription(resource, (IDefaultResourceDescriptionStrategy)this.descriptionStrategy, this.cache);
                if (!initialized) {
                    for (IEObjectDescription d : result.getExportedObjects()) {
                        d.getEObjectURI();
                    }
                }
                DefaultResourceDescription defaultResourceDescription = result;
                return defaultResourceDescription;
            }
            finally {
                if (!initialized) {
                    javaResource.discardDerivedState();
                    javaResource.eSetDeliver(true);
                }
            }
        }
        throw new IllegalArgumentException("Can only handle JavaResources");
    }

    public boolean isAffected(IResourceDescription.Delta delta, IResourceDescription candidate) throws IllegalArgumentException {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) throws IllegalArgumentException {
        Set importedNames = IterableExtensions.toSet((Iterable)candidate.getImportedNames());
        for (IResourceDescription.Delta delta : deltas) {
            if (!this.hasChanges(delta, candidate) || !this.isAffected(importedNames, delta.getNew()) && !this.isAffected(importedNames, delta.getOld())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasChanges(IResourceDescription.Delta delta, IResourceDescription candidate) {
        return delta.haveEObjectDescriptionsChanged();
    }

    protected boolean isAffected(Collection<QualifiedName> importedNames, IResourceDescription description) {
        if (description != null) {
            for (IEObjectDescription desc : description.getExportedObjects()) {
                if (!importedNames.contains(desc.getName().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

