/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IPageValidator;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class ConfigureSynchronizeScheduleComposite
extends Composite {
    private SubscriberRefreshSchedule schedule;
    private Button enableBackgroundRefresh;
    private Text timeInterval;
    private Combo hoursOrMinutes;
    private IPageValidator validator;
    private DateTime startTime;
    private Button repeatEvery;
    private Label synchronizeAt;

    public ConfigureSynchronizeScheduleComposite(Composite parent, SubscriberRefreshSchedule schedule, IPageValidator validator) {
        super(parent, 0);
        this.schedule = schedule;
        this.validator = validator;
        this.createMainDialogArea(parent);
    }

    private void initializeValues() {
        long minutes;
        boolean enableBackground = this.schedule.isEnabled();
        boolean hours = false;
        this.enableBackgroundRefresh.setSelection(enableBackground);
        long seconds = this.schedule.getRefreshInterval();
        if (seconds <= 60L) {
            seconds = 60L;
        }
        if ((minutes = seconds / 60L) >= 60L) {
            minutes /= 60L;
            hours = true;
        }
        this.hoursOrMinutes.select(hours ? 0 : 1);
        this.timeInterval.setText(Long.toString(minutes));
        this.repeatEvery.setSelection(!this.schedule.getRunOnce());
        Date start = this.schedule.getRefreshStartTime();
        Calendar cal = Calendar.getInstance();
        if (start != null) {
            cal.setTime(start);
            this.startTime.setTime(cal.get(11), cal.get(12), cal.get(13));
        } else {
            this.startTime.setTime(0, 0, 0);
        }
    }

    protected void createMainDialogArea(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        gridLayout.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        ConfigureSynchronizeScheduleComposite area = this;
        this.createWrappingLabel(area, NLS.bind((String)TeamUIMessages.ConfigureRefreshScheduleDialog_1, (Object[])new String[]{Utils.shortenText(100, this.schedule.getParticipant().getName())}), 0, 3);
        this.enableBackgroundRefresh = new Button((Composite)area, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.enableBackgroundRefresh.setLayoutData((Object)gridData);
        this.enableBackgroundRefresh.setText(TeamUIMessages.ConfigureRefreshScheduleDialog_3);
        this.enableBackgroundRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.synchronizeAt = ConfigureSynchronizeScheduleComposite.createIndentedLabel(area, TeamUIMessages.ConfigureRefreshScheduleDialog_3a, 20);
        this.startTime = new DateTime((Composite)area, 2176);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.startTime.setLayoutData((Object)gridData);
        this.repeatEvery = ConfigureSynchronizeScheduleComposite.createIndentedButton(area, TeamUIMessages.ConfigureRefreshScheduleDialog_4, 20);
        this.repeatEvery.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.timeInterval = new Text((Composite)area, 133120);
        gridData = new GridData();
        gridData.widthHint = 35;
        this.timeInterval.setLayoutData((Object)gridData);
        this.timeInterval.addModifyListener(e -> this.updateEnablements());
        this.timeInterval.addVerifyListener(e -> {
            String string = e.text;
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if ('0' > chars[i] || chars[i] > '9') {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        });
        this.hoursOrMinutes = new Combo((Composite)area, 8);
        this.hoursOrMinutes.setItems(new String[]{TeamUIMessages.ConfigureRefreshScheduleDialog_5, TeamUIMessages.ConfigureRefreshScheduleDialog_6});
        this.hoursOrMinutes.setLayoutData((Object)new GridData());
        Label label = new Label((Composite)area, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(NLS.bind((String)TeamUIMessages.ConfigureRefreshScheduleDialog_2, (Object[])new String[]{SubscriberRefreshSchedule.refreshEventAsString(this.schedule.getLastRefreshEvent())}));
        this.initializeValues();
        this.updateEnablements();
    }

    public void saveValues() {
        ISynchronizeParticipant participant;
        if (this.enableBackgroundRefresh.getSelection()) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, this.startTime.getHours());
            cal.set(12, this.startTime.getMinutes());
            cal.set(13, this.startTime.getSeconds());
            this.schedule.setRefreshStartTime(cal.getTime());
            if (this.repeatEvery.getSelection()) {
                int hours = this.hoursOrMinutes.getSelectionIndex();
                try {
                    long seconds = Long.parseLong(this.timeInterval.getText());
                    seconds = hours == 0 ? (seconds *= 3600L) : (seconds *= 60L);
                    this.schedule.setRefreshInterval(seconds);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.schedule.setRunOnce(true);
            }
        }
        if (this.schedule.isEnabled() != this.enableBackgroundRefresh.getSelection()) {
            this.schedule.setEnabled(this.enableBackgroundRefresh.getSelection(), true);
        }
        if (!(participant = this.schedule.getParticipant()).isPinned() && this.schedule.isEnabled()) {
            participant.setPinned(MessageDialog.openQuestion((Shell)this.getShell(), (String)NLS.bind((String)TeamUIMessages.ConfigureSynchronizeScheduleComposite_0, (Object[])new String[]{Utils.getTypeName(participant)}), (String)NLS.bind((String)TeamUIMessages.ConfigureSynchronizeScheduleComposite_1, (Object[])new String[]{Utils.getTypeName(participant)})));
        }
        this.schedule.getRefreshable().setRefreshSchedule(this.schedule);
    }

    public void updateEnablements() {
        if (!this.enableBackgroundRefresh.getSelection()) {
            this.validator.setComplete(null);
        } else if (this.repeatEvery.getSelection()) {
            try {
                long number = Long.parseLong(this.timeInterval.getText());
                if (number <= 0L) {
                    this.validator.setComplete(TeamUIMessages.ConfigureRefreshScheduleDialog_7);
                } else {
                    this.validator.setComplete(null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.validator.setComplete(TeamUIMessages.ConfigureRefreshScheduleDialog_7);
            }
        }
        this.synchronizeAt.setEnabled(this.enableBackgroundRefresh.getSelection());
        this.startTime.setEnabled(this.enableBackgroundRefresh.getSelection());
        this.repeatEvery.setEnabled(this.enableBackgroundRefresh.getSelection());
        this.timeInterval.setEnabled(this.enableBackgroundRefresh.getSelection() && this.repeatEvery.getSelection());
        this.hoursOrMinutes.setEnabled(this.enableBackgroundRefresh.getSelection() && this.repeatEvery.getSelection());
    }

    private Label createWrappingLabel(Composite parent, String text, int indent, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    private static Label createIndentedLabel(Composite parent, String text, int indent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        return label;
    }

    private static Button createIndentedButton(Composite parent, String text, int indent) {
        Button label = new Button(parent, 32);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        return label;
    }
}

