/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.permission;

import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;

public abstract class AbstractPermissionAuthority
implements IPermissionAuthority {
    protected boolean listen;
    protected List<IAuthorityListener> listeners = new CopyOnWriteArrayList<IAuthorityListener>();
    protected ConcurrentMap<Object, Object> lockedObjects = new MapMaker().concurrencyLevel(4).weakKeys().makeMap();

    protected boolean isLocked(EObject eObject) {
        return this.lockedObjects.containsKey(eObject);
    }

    protected void storeAsLockedAndNotify(EObject eObject) {
        this.lockedObjects.put(eObject, true);
        for (IAuthorityListener listener : this.listeners) {
            listener.notifyIsLocked(eObject);
        }
    }

    protected void releaseFromLockedAndNotify(EObject eObject) {
        this.lockedObjects.remove(eObject);
        for (IAuthorityListener listener : this.listeners) {
            listener.notifyIsReleased(eObject);
        }
    }

    @Override
    public void addAuthorityListener(IAuthorityListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void dispose(ResourceSet set) {
        this.listeners.clear();
        this.lockedObjects.clear();
    }

    @Override
    public void init(ResourceSet set) {
    }

    @Override
    public void removeAuthorityListener(IAuthorityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setListening(boolean shouldListen) {
        this.listen = shouldListen;
    }

    @Override
    public boolean isChanged(EObject instance) {
        return false;
    }

    @Override
    public boolean isNewInstance(EObject instance) {
        return false;
    }
}

