/*
 * Decompiled with CFR 0.152.
 */
package dispatching.util;

import activity.Activity;
import activity.ActivitySet;
import activity.ResourceAction;
import activity.util.ActivityUtil;
import dispatching.ActivityDispatching;
import dispatching.Attribute;
import dispatching.Dispatch;
import dispatching.DispatchGroup;
import dispatching.DispatchingFactory;
import dispatching.DispatchingPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import machine.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DispatchingUtil {
    private DispatchingUtil() {
    }

    public static void expand(ActivityDispatching dispatching) {
        DispatchingUtil.unfold(dispatching);
        DispatchingUtil.expandActivities(dispatching);
    }

    public static void expandActivities(ActivityDispatching dispatching) {
        LinkedHashSet remove = new LinkedHashSet();
        dispatching.getDispatchGroups().stream().flatMap(dg -> dg.getDispatches().stream()).filter(d -> !d.getResourceItems().isEmpty()).forEach(d -> {
            remove.add(d.getActivity());
            d.setActivity(ActivityUtil.queryCreateExpandedActivity((Activity)d.getActivity(), d.getResourceItems()));
            d.getResourceItems().clear();
        });
    }

    public static void unfold(ActivityDispatching dispatching) {
        DispatchingUtil.convertYield(dispatching);
        for (DispatchGroup dg : new ArrayList<DispatchGroup>((Collection<DispatchGroup>)dispatching.getDispatchGroups())) {
            DispatchGroup newGroup = (DispatchGroup)EcoreUtil.copy((EObject)dg);
            dispatching.getDispatchGroups().add(dispatching.getDispatchGroups().indexOf((Object)dg), (Object)newGroup);
            int numberRepeats = DispatchingUtil.getNumberRepeats(dg);
            newGroup.setYield(DispatchingUtil.getYield(dg) * numberRepeats);
            newGroup.getResourceYield().forEach(d -> d.setValue(numberRepeats * DispatchingUtil.getYield(newGroup, (IResource)d.getKey())));
            newGroup.getRepeats().clear();
            newGroup.eUnset((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__ITERATOR_NAME);
            newGroup.getDispatches().clear();
            Integer[] integerArray = DispatchingUtil.getRepeatSeries(dg);
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer iteration = integerArray[n2];
                for (Dispatch d2 : dg.getDispatches()) {
                    Dispatch newDispatch = (Dispatch)EcoreUtil.copy((EObject)d2);
                    if (newDispatch.getDescription() != null) {
                        DispatchingUtil.userAttr(newDispatch, "description", d2.getDescription());
                        newDispatch.setDescription(null);
                    }
                    DispatchingUtil.userAttr(newDispatch, "phase", dg.getName());
                    DispatchingUtil.userAttr(newDispatch, dg.getIteratorName(), Integer.toString(iteration));
                    newGroup.getDispatches().add((Object)newDispatch);
                }
                ++n2;
            }
            dispatching.getDispatchGroups().remove((Object)dg);
        }
    }

    public static ActivityDispatching convertYield(ActivityDispatching dispatching) {
        if (dispatching.eIsSet((EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS) || dispatching.getResourceIterations().size() > 0) {
            for (DispatchGroup dg : new ArrayList<DispatchGroup>((Collection<DispatchGroup>)dispatching.getDispatchGroups())) {
                dg.setYield(DispatchingUtil.getYield(dg));
                Collection<IResource> resources = DispatchingUtil.getResources(dg);
                dg.getResourceYield().forEach(d -> resources.remove(d.getKey()));
                dispatching.getResourceIterations().stream().filter(r -> resources.contains(r.getKey())).forEach(r -> {
                    Object object = dg.getResourceYield().put((Object)((IResource)r.getKey()), (Object)((Integer)r.getValue()));
                });
            }
            dispatching.eUnset((EStructuralFeature)DispatchingPackage.Literals.ACTIVITY_DISPATCHING__NUMBER_OF_ITERATIONS);
            dispatching.getResourceIterations().clear();
        }
        return dispatching;
    }

    public static void removeUnusedActivities(ActivityDispatching dispatching) {
        Collection used = dispatching.getDispatchGroups().stream().flatMap(dg -> dg.getDispatches().stream()).map(d -> d.getActivity()).collect(Collectors.toCollection(LinkedHashSet::new));
        Collection activitySets = used.stream().map(EObject::eContainer).filter(ActivitySet.class::isInstance).map(ActivitySet.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
        Collection remove = activitySets.stream().flatMap(as -> as.getActivities().stream()).filter(a -> !used.contains(a)).collect(Collectors.toCollection(LinkedHashSet::new));
        remove.forEach(a -> {
            boolean bl = ((ActivitySet)a.eContainer()).getActivities().remove(a);
        });
    }

    public static Collection<IResource> getResources(DispatchGroup group) {
        return group.getDispatches().stream().map(Dispatch::getActivity).flatMap(a -> a.getNodes().stream()).filter(ResourceAction.class::isInstance).map(ResourceAction.class::cast).map(ResourceAction::getResource).distinct().collect(Collectors.toSet());
    }

    public static int getNumberRepeats(DispatchGroup group) {
        return DispatchingUtil.getRepeatSeries(group).length;
    }

    public static int getYield(DispatchGroup dg, IResource resource) {
        Integer result = (Integer)dg.getResourceYield().get((Object)resource);
        return result != null ? result : (dg.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__YIELD) ? dg.getYield() : DispatchingUtil.getYield((ActivityDispatching)dg.eContainer(), resource));
    }

    private static Integer[] getRepeatSeries(DispatchGroup group) {
        if (group.getRepeats().size() == 0) {
            return new Integer[]{1};
        }
        return (Integer[])group.getRepeats().stream().flatMap(r -> IntStream.range(r.getStart(), r.getStart() + r.getCount()).boxed()).toArray(Integer[]::new);
    }

    private static int getYield(DispatchGroup dg) {
        return dg.eIsSet((EStructuralFeature)DispatchingPackage.Literals.DISPATCH_GROUP__YIELD) ? dg.getYield() : ((ActivityDispatching)dg.eContainer()).getNumberOfIterations();
    }

    private static int getYield(ActivityDispatching ad, IResource resource) {
        if (ad != null) {
            Integer result = (Integer)ad.getResourceIterations().get((Object)resource);
            return result != null ? result.intValue() : ad.getNumberOfIterations();
        }
        return 1;
    }

    private static void userAttr(Dispatch group, String name, String value) {
        Attribute attribute = DispatchingFactory.eINSTANCE.createAttribute();
        attribute.setName(name);
        group.getUserAttributes().put((Object)attribute, (Object)value);
    }
}

