/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.Styler;

public class ChartText
implements ChartPart {
    protected XChartPanel chartPanel;
    protected Chart chart;
    protected Rectangle bounds;
    protected String text;
    protected boolean visible = true;
    protected Color fontColor;
    protected Font textFont;
    protected double xValue;
    protected double yValue;
    protected boolean valueInScreenCoordinate = false;
    double startx;
    double starty;

    public ChartText(String text, double xValue, double yValue, boolean valueInScreenCoordinate) {
        this.text = text;
        this.xValue = xValue;
        this.yValue = yValue;
        this.valueInScreenCoordinate = valueInScreenCoordinate;
    }

    public void init(XChartPanel<XYChart> chartPanel) {
        this.chartPanel = chartPanel;
        this.chart = chartPanel.getChart();
        if (this.fontColor == null) {
            this.fontColor = ((Styler)this.chart.getStyler()).getChartFontColor();
        }
        if (this.textFont == null) {
            this.textFont = ((Styler)this.chart.getStyler()).getLegendFont();
        }
        this.chart.addPlotPart(this);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    protected void calculatePosition(Rectangle2D textBounds) {
        if (this.valueInScreenCoordinate) {
            this.startx = this.xValue;
            this.starty = this.yValue;
        } else {
            this.startx = this.chart.getScreenXFromChart(this.xValue) - textBounds.getWidth() / 2.0;
            this.starty = this.chart.getScreenYFromChart(this.yValue) + textBounds.getHeight() / 2.0;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.bounds = g.getClipBounds();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.fontColor);
        g.setFont(this.textFont);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout tl = new TextLayout(this.text, this.textFont, frc);
        Shape shape = tl.getOutline(null);
        Rectangle2D textBounds = shape.getBounds2D();
        this.calculatePosition(textBounds);
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(this.startx, this.starty);
        g.transform(at);
        g.fill(shape);
        g.setTransform(orig);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public double getxValue() {
        return this.xValue;
    }

    public void setxValue(double xValue) {
        this.xValue = xValue;
    }

    public double getyValue() {
        return this.yValue;
    }

    public void setyValue(double yValue) {
        this.yValue = yValue;
    }

    public boolean isValueInScreenCoordinate() {
        return this.valueInScreenCoordinate;
    }

    public void setValueInScreenCoordinate(boolean valueInScreenCoordinate) {
        this.valueInScreenCoordinate = valueInScreenCoordinate;
    }
}

