/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.event.EventListenerList;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.Styler;

public class ChartButton
extends MouseAdapter
implements ChartPart {
    protected XChartPanel chartPanel;
    protected Chart chart;
    protected Rectangle bounds;
    protected Color color = new Color(114, 147, 203);
    protected Color hoverColor = new Color(57, 106, 177);
    protected String text;
    protected boolean visible = true;
    protected Color fontColor;
    protected Font textFont;
    protected Color borderColor;
    protected int margin = 6;
    protected ActionEvent action;
    protected Styler.LegendPosition position = Styler.LegendPosition.InsideN;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    private Shape buttonRect;
    private boolean mouseOver;
    protected EventListenerList listenerList = new EventListenerList();

    public ChartButton(String text) {
        this.text = text;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (this.action == null) {
                this.action = new ActionEvent(this, 1001, this.text);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(this.action);
        }
    }

    public void init(XChartPanel<XYChart> chartPanel) {
        this.chartPanel = chartPanel;
        this.chart = chartPanel.getChart();
        if (this.fontColor == null) {
            this.fontColor = ((Styler)this.chart.getStyler()).getChartFontColor();
        }
        if (this.textFont == null) {
            this.textFont = ((Styler)this.chart.getStyler()).getLegendFont();
        }
        if (this.borderColor == null) {
            this.borderColor = ((Styler)this.chart.getStyler()).getLegendBorderColor();
        }
        chartPanel.addMouseListener(this);
        chartPanel.addMouseMotionListener(this);
        this.chart.addPlotPart(this);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.visible) {
            return;
        }
        if (this.buttonRect == null) {
            return;
        }
        if (this.buttonRect.contains(e.getX(), e.getY())) {
            this.fireActionPerformed();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.visible) {
            return;
        }
        if (this.buttonRect == null) {
            return;
        }
        if (this.buttonRect.contains(e.getX(), e.getY())) {
            this.mouseOver = true;
            this.repaint();
        } else if (this.mouseOver) {
            this.mouseOver = false;
            this.repaint();
        }
    }

    protected void repaint() {
        this.chartPanel.invalidate();
        this.chartPanel.repaint();
    }

    protected void calculatePosition(Rectangle2D textBounds) {
        double textHeight = textBounds.getHeight();
        double textWidth = textBounds.getWidth();
        double widthAdjustment = textWidth + (double)(this.margin * 3);
        double heightAdjustment = textHeight + (double)(this.margin * 3);
        double boundsWidth = this.bounds.getWidth();
        double boundsHeight = this.bounds.getHeight();
        if (this.position != null) {
            switch (this.position) {
                case InsideNW: {
                    this.xOffset = this.bounds.getX() + (double)this.margin;
                    this.yOffset = this.bounds.getY() + (double)this.margin;
                    break;
                }
                case InsideNE: {
                    this.xOffset = this.bounds.getX() + boundsWidth - widthAdjustment;
                    this.yOffset = this.bounds.getY() + (double)this.margin;
                    break;
                }
                case InsideSE: {
                    this.xOffset = this.bounds.getX() + boundsWidth - widthAdjustment;
                    this.yOffset = this.bounds.getY() + boundsHeight - heightAdjustment;
                    break;
                }
                case InsideSW: {
                    this.xOffset = this.bounds.getX() + (double)this.margin;
                    this.yOffset = this.bounds.getY() + boundsHeight - heightAdjustment;
                    break;
                }
                case InsideN: {
                    this.xOffset = this.bounds.getX() + boundsWidth / 2.0 - textWidth / 2.0 - (double)this.margin;
                    this.yOffset = this.bounds.getY() + (double)this.margin;
                    break;
                }
                case InsideS: {
                    this.xOffset = this.bounds.getX() + boundsWidth / 2.0 - textWidth / 2.0 - (double)this.margin;
                    this.yOffset = this.bounds.getY() + boundsHeight - heightAdjustment;
                    break;
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.bounds = g.getClipBounds();
        double boundsWidth = this.bounds.getWidth();
        if (boundsWidth < 30.0) {
            return;
        }
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.fontColor);
        g.setFont(this.textFont);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout tl = new TextLayout(this.text, this.textFont, frc);
        Shape shape = tl.getOutline(null);
        Rectangle2D textBounds = shape.getBounds2D();
        this.calculatePosition(textBounds);
        double textHeight = textBounds.getHeight();
        double textWidth = textBounds.getWidth();
        this.buttonRect = new Rectangle2D.Double(this.xOffset, this.yOffset, textWidth + (double)(this.margin * 2), textHeight + (double)(this.margin * 2));
        if (this.mouseOver) {
            g.setColor(this.hoverColor);
        } else {
            g.setColor(this.color);
        }
        g.fill(this.buttonRect);
        g.setStroke(SOLID_STROKE);
        g.setColor(this.borderColor);
        g.draw(this.buttonRect);
        double startx = this.xOffset + (double)this.margin;
        double starty = this.yOffset + (double)this.margin;
        g.setColor(this.fontColor);
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(startx, starty + textHeight);
        g.transform(at);
        g.fill(shape);
        g.setTransform(orig);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (!visible) {
            this.mouseOver = false;
        }
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public ActionEvent getAction() {
        return this.action;
    }

    public void setAction(ActionEvent action) {
        this.action = action;
    }

    public double getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(double xOffset) {
        this.xOffset = xOffset;
    }

    public double getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(double yOffset) {
        this.yOffset = yOffset;
    }

    public void setPosition(Styler.LegendPosition position) {
        this.position = position;
    }
}

