/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.parser.ast.parser;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.setext.parser.ast.SeTextObject;

public class JavaType
extends SeTextObject {
    public String className;
    public List<JavaType> genericTypeParams;

    public JavaType(String className, List<JavaType> genericTypeParams, Position position) {
        super(position);
        this.className = className;
        this.genericTypeParams = genericTypeParams;
        if (genericTypeParams != null) {
            Assert.check((!genericTypeParams.isEmpty() ? 1 : 0) != 0);
        }
    }

    public boolean isGeneric() {
        return this.genericTypeParams != null;
    }

    public String getSimpleClassName() {
        String rslt = this.className;
        int idx = rslt.lastIndexOf(46);
        if (idx != -1) {
            rslt = rslt.substring(idx + 1);
        }
        return rslt;
    }

    public String getPackageName() {
        int idx = this.className.lastIndexOf(46);
        return idx == -1 ? "" : Strings.slice((String)this.className, null, (Integer)idx);
    }

    public Set<String> getNames() {
        Set names = Sets.set((Object)this.className);
        if (this.genericTypeParams != null) {
            for (JavaType param : this.genericTypeParams) {
                names.addAll(param.getNames());
            }
        }
        return names;
    }

    public String toString() {
        StringBuilder rslt = new StringBuilder();
        rslt.append(this.className);
        if (this.genericTypeParams != null) {
            rslt.append("<");
            rslt.append(StringUtils.join(this.genericTypeParams, (String)", "));
            rslt.append(">");
        }
        return rslt.toString();
    }

    public String toSimpleString() {
        StringBuilder rslt = new StringBuilder();
        rslt.append(this.getSimpleClassName());
        if (this.genericTypeParams != null) {
            rslt.append("<");
            List paramTxts = Lists.list();
            for (JavaType param : this.genericTypeParams) {
                paramTxts.add(param.toSimpleString());
            }
            rslt.append(StringUtils.join((Collection)paramTxts, (String)", "));
            rslt.append(">");
        }
        return rslt.toString();
    }
}

