/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.api.MatrixDependencies;
import org.eclipse.lsat.common.ludus.backend.fsm.PrintToCIF;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.por.ClusterPORPerformance;
import org.eclipse.lsat.common.ludus.backend.por.ClusterPORPerformanceFunctional;
import org.eclipse.lsat.common.ludus.backend.por.DependencyGraph;
import org.eclipse.lsat.common.ludus.backend.por.PrePostProcessor;
import org.eclipse.lsat.common.mpt.Edge;
import org.eclipse.lsat.common.mpt.FSM;
import org.eclipse.lsat.common.mpt.FSMTransition;
import org.eclipse.lsat.common.mpt.FSMType;
import org.eclipse.lsat.common.mpt.Matrix;
import org.eclipse.lsat.common.mpt.MaxPlusSpecification;
import org.eclipse.lsat.common.mpt.RowVector;
import org.eclipse.lsat.common.mpt.api.MaxPlusException;
import org.eclipse.lsat.common.mpt.api.MaximumMakespanResult;
import org.eclipse.lsat.common.mpt.api.MaximumThroughputResult;
import org.eclipse.lsat.common.mpt.api.MinimumMakespanResult;
import org.eclipse.lsat.common.mpt.api.MinimumThroughputResult;
import org.eclipse.lsat.common.mpt.api.NotAllResourcesLinkedException;
import org.eclipse.lsat.common.mpt.api.SpecificationFSMResult;
import org.eclipse.lsat.common.mpt.api.SpecificationTraverser;
import org.eclipse.lsat.common.mpt.api.SpecificationValidator;
import org.eclipse.lsat.common.mpt.api.UnconnectedResourceException;
import org.eclipse.lsat.common.mpt.api.adapter.FSMAdapter;
import org.eclipse.lsat.common.mpt.api.adapter.MatrixAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MaxPlusAlgorithms {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaxPlusAlgorithms.class);
    public static final double SCALING_FACTOR = 1000000.0;

    private MaxPlusAlgorithms() {
    }

    public static MinimumMakespanResult calculateMinimumMakespan(MaxPlusSpecification specification) throws MaxPlusException {
        String startErrorMessage = "Minimum makespan cannot be calculated. ";
        try {
            SpecificationFSMResult fsmResult = MaxPlusAlgorithms.loadFSM(specification);
            org.eclipse.lsat.common.ludus.api.MinimumMakespanResult result = org.eclipse.lsat.common.ludus.api.MaxPlusAlgorithms.calculateMinimumMakespan(fsmResult.getFSM(), fsmResult.getActivityMatrixMap());
            return new MinimumMakespanResult(result.getMakespan() / 1000000.0, result.getEvents());
        }
        catch (org.eclipse.lsat.common.ludus.api.MaxPlusException e) {
            throw new MaxPlusException(String.valueOf(startErrorMessage) + e.getMessage());
        }
    }

    public static MaximumMakespanResult calculateMaximumMakespan(MaxPlusSpecification specification) throws MaxPlusException {
        String startErrorMessage = "Maximum makespan cannot be calculated. ";
        try {
            SpecificationFSMResult fsmResult = MaxPlusAlgorithms.loadFSM(specification);
            org.eclipse.lsat.common.ludus.api.MaximumMakespanResult result = org.eclipse.lsat.common.ludus.api.MaxPlusAlgorithms.calculateMaximumMakespan(fsmResult.getFSM(), fsmResult.getActivityMatrixMap());
            return new MaximumMakespanResult(result.getMakespan() / 1000000.0, result.getEvents());
        }
        catch (org.eclipse.lsat.common.ludus.api.MaxPlusException e) {
            throw new MaxPlusException(String.valueOf(startErrorMessage) + e.getMessage());
        }
    }

    public static MaximumThroughputResult calculateMaximumThroughput(MaxPlusSpecification specification) throws MaxPlusException {
        String startErrorMessage = "Maximum throughput cannot be calculated. ";
        try {
            SpecificationFSMResult fsmResult = MaxPlusAlgorithms.loadFSM(specification);
            org.eclipse.lsat.common.ludus.api.MaximumThroughputResult result = org.eclipse.lsat.common.ludus.api.MaxPlusAlgorithms.calculateMaximumThroughput(fsmResult.getFSM(), fsmResult.getActivityMatrixMap());
            return new MaximumThroughputResult(result.getThroughput() * 1000000.0, result.getSteadyStateEvents(), result.getTransientStateEvents());
        }
        catch (org.eclipse.lsat.common.ludus.api.MaxPlusException e) {
            throw new MaxPlusException(String.valueOf(startErrorMessage) + e.getMessage());
        }
        catch (NotAllResourcesLinkedException e) {
            String cycle = e.getSimpleCycle().stream().map(loc -> String.valueOf(loc)).collect(Collectors.joining("->", "(", ")"));
            List resourceNames = ((Matrix)specification.getMatrices().iterator().next()).getRows().stream().map(row -> row.getName()).collect(Collectors.toList());
            String missingClaimDependencies = e.getMissingClaimPairs().stream().map(tup -> String.valueOf((String)resourceNames.get((Integer)tup.getLeft())) + " to " + (String)resourceNames.get((Integer)tup.getRight())).collect(Collectors.joining(", ", "", ""));
            throw new MaxPlusException(String.valueOf(startErrorMessage) + e.getMessage() + " " + cycle + " missing claim dependencies from " + missingClaimDependencies);
        }
        catch (UnconnectedResourceException e) {
            List resourceNames = ((Matrix)specification.getMatrices().iterator().next()).getRows().stream().map(row -> row.getName()).collect(Collectors.toList());
            String resName = (String)resourceNames.get(e.getResourceId());
            throw new MaxPlusException(String.valueOf(e.getMessage()) + " Resource " + resName + " is not connected to other resources.");
        }
    }

    public static MinimumThroughputResult calculateMinimumThroughput(MaxPlusSpecification specification) throws MaxPlusException {
        String startErrorMessage = "Minimum throughput cannot be calculated. ";
        try {
            SpecificationFSMResult fsmResult = MaxPlusAlgorithms.loadFSM(specification);
            org.eclipse.lsat.common.ludus.api.MinimumThroughputResult result = org.eclipse.lsat.common.ludus.api.MaxPlusAlgorithms.calculateMinimumThroughput(fsmResult.getFSM(), fsmResult.getActivityMatrixMap());
            return new MinimumThroughputResult(result.getThroughput() * 1000000.0, result.getEvents());
        }
        catch (org.eclipse.lsat.common.ludus.api.MaxPlusException e) {
            throw new MaxPlusException(String.valueOf(startErrorMessage) + e.getMessage());
        }
    }

    public static String applyClusterReductionPerformance(MaxPlusSpecification specification, String compositionName) throws MaxPlusException {
        List<FSM> fsmList = SpecificationTraverser.findAllFSMs(specification);
        if (fsmList.isEmpty()) {
            throw new MaxPlusException("The specification contains no FSM.");
        }
        HashMap<String, org.eclipse.lsat.common.ludus.backend.algebra.Matrix> mapping = new HashMap<String, org.eclipse.lsat.common.ludus.backend.algebra.Matrix>();
        for (FSM fsm : fsmList) {
            for (Edge e : fsm.getEdges()) {
                FSMTransition t = (FSMTransition)e;
                if (t.getMatrix() == null) {
                    throw new MaxPlusException("Cannot find matrix for event " + t.getName() + ".");
                }
                mapping.put(t.getName(), MatrixAdapter.getMatrix(t.getMatrix()).getLeft());
            }
        }
        DependencyGraph dependencies = MatrixDependencies.getDependencyGraphResourceSharing(mapping);
        ArrayList<org.eclipse.lsat.common.ludus.backend.fsm.FSM<Location, org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge>> backendFSMlist = new ArrayList<org.eclipse.lsat.common.ludus.backend.fsm.FSM<Location, org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge>>();
        for (FSM fsm : fsmList) {
            FSMImpl backendFSM = FSMAdapter.getFSM(specification, fsm);
            backendFSMlist.add(backendFSM);
        }
        ClusterPORPerformance clusterPOR = new ClusterPORPerformance();
        FSMImpl result = clusterPOR.compute(backendFSMlist, dependencies);
        LOGGER.info("POR finished. Size of resulting supervisor: " + result.getVertices().size() + " vertices, " + result.getEdges().size() + " edges.");
        return PrintToCIF.print(result, compositionName);
    }

    public static String applyClusterReductionPerformanceFunctional(MaxPlusSpecification specification, String compositionName) throws MaxPlusException {
        List<FSM> fsmList = SpecificationTraverser.findAllFSMs(specification);
        if (fsmList.isEmpty()) {
            throw new MaxPlusException("The specification contains no FSM.");
        }
        HashMap<String, org.eclipse.lsat.common.ludus.backend.algebra.Matrix> mapping = new HashMap<String, org.eclipse.lsat.common.ludus.backend.algebra.Matrix>();
        for (FSM fsm : fsmList) {
            for (Edge e : fsm.getEdges()) {
                FSMTransition t = (FSMTransition)e;
                if (t.getMatrix() == null) {
                    throw new MaxPlusException("Cannot find matrix for event " + t.getName() + ".");
                }
                mapping.put(t.getName(), MatrixAdapter.getMatrix(t.getMatrix()).getLeft());
            }
        }
        DependencyGraph dependencies = MatrixDependencies.getDependencyGraphResourceSharing(mapping);
        ArrayList<org.eclipse.lsat.common.ludus.backend.fsm.FSM<Location, org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge>> backendFSMlist = new ArrayList<org.eclipse.lsat.common.ludus.backend.fsm.FSM<Location, org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge>>();
        for (FSM fsm : fsmList) {
            FSMImpl backendFSM = FSMAdapter.getFSM(specification, fsm);
            if (fsm.getType().equals((Object)FSMType.REQUIREMENT)) {
                backendFSM = PrePostProcessor.plantify(backendFSM);
            }
            backendFSM = PrePostProcessor.addOmegaLoops(backendFSM);
            backendFSMlist.add(backendFSM);
        }
        ClusterPORPerformanceFunctional clusterPOR = new ClusterPORPerformanceFunctional();
        FSMImpl result = clusterPOR.compute(backendFSMlist, dependencies);
        result = PrePostProcessor.removeOmegaLoops(result);
        LOGGER.info("POR finished. Size of resulting supervisor: " + result.getVertices().size() + " vertices, " + result.getEdges().size() + " edges.");
        return PrintToCIF.print(result, compositionName);
    }

    private static SpecificationFSMResult loadFSM(MaxPlusSpecification specification) throws MaxPlusException {
        List<FSM> fsms = SpecificationTraverser.findAllFSMs(specification);
        if (fsms.isEmpty()) {
            throw new MaxPlusException("The specification contains no FSM.");
        }
        if (fsms.size() > 1) {
            throw new MaxPlusException("The specification contains multiple FSMs.");
        }
        return MaxPlusAlgorithms.computeSpecificationFSM(specification, fsms.get(0));
    }

    private static SpecificationFSMResult computeSpecificationFSM(MaxPlusSpecification specification, FSM fsm) throws MaxPlusException {
        FSMImpl backendFSM = FSMAdapter.getFSM(specification, fsm);
        HashMap<String, org.eclipse.lsat.common.ludus.backend.algebra.Matrix> mapping = new HashMap<String, org.eclipse.lsat.common.ludus.backend.algebra.Matrix>();
        LinkedList<Matrix> matrixList = new LinkedList<Matrix>();
        for (Edge e : fsm.getEdges()) {
            FSMTransition t = (FSMTransition)e;
            if (t.getMatrix() == null) {
                throw new MaxPlusException("Cannot find matrix for activity " + t.getName() + ".");
            }
            matrixList.add(t.getMatrix());
        }
        if (!SpecificationValidator.allMatricesSameSize(matrixList)) {
            throw new MaxPlusException("Matrices have different sizes!");
        }
        Set<Integer> notConnectedResourceIds = SpecificationValidator.findUnconnectedResources(matrixList);
        Set notConnectedResources = notConnectedResourceIds.stream().map(id -> ((RowVector)((Matrix)matrixList.iterator().next()).getRows().get(id.intValue())).getName()).collect(Collectors.toSet());
        if (notConnectedResources.size() == 1) {
            LOGGER.warn("Resource " + (String)notConnectedResources.iterator().next() + " does not have any incoming dependency from another resource. " + "This might lead to generation of an infinite max-plus state space.");
        } else if (notConnectedResources.size() > 1) {
            LOGGER.warn("Resources " + String.join((CharSequence)",", notConnectedResources) + " do not have any incoming dependency from another resource. " + "This might lead to generation of an infinite max-plus state space.");
        }
        Set<Integer> unusedResourcesById = SpecificationValidator.findUnusedResources(matrixList);
        Set unusedResources = unusedResourcesById.stream().map(id -> ((RowVector)((Matrix)matrixList.iterator().next()).getRows().get(id.intValue())).getName()).collect(Collectors.toSet());
        if (unusedResources.size() == 1) {
            LOGGER.warn("Resource " + (String)unusedResources.iterator().next() + " is not updated by any of the activities. " + "Resource is not taken into account during performance analysis.");
        } else if (unusedResources.size() > 1) {
            LOGGER.warn("Resources " + String.join((CharSequence)",", unusedResources) + " are not updated by any of the activities. " + "Resources are not taken into account during performance analysis.");
        }
        for (Edge e : fsm.getEdges()) {
            FSMTransition t = (FSMTransition)e;
            mapping.put(t.getName(), MatrixAdapter.getMatrix(t.getMatrix(), unusedResourcesById).getLeft());
        }
        int vecSize = ((org.eclipse.lsat.common.ludus.backend.algebra.Matrix)mapping.values().iterator().next()).getColumns();
        return new SpecificationFSMResult(backendFSM, vecSize, mapping);
    }
}

