/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.simple_single;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.graph.simple_single.SSEdge;

public class SSVertex
implements Comparable<SSVertex> {
    private int id;
    private Map<SSVertex, SSEdge> outgoing;
    private Map<SSVertex, SSEdge> incoming;

    public SSVertex() {
        this.id = this.hashCode();
        this.outgoing = new HashMap<SSVertex, SSEdge>();
        this.incoming = new HashMap<SSVertex, SSEdge>();
    }

    public Collection<SSEdge> getIncoming() {
        return this.incoming.values();
    }

    public SSEdge getIncoming(SSVertex source) {
        return this.incoming.get(source);
    }

    public Collection<SSEdge> getOutgoing() {
        return this.outgoing.values();
    }

    public SSEdge getOutgoing(SSVertex target) {
        return this.outgoing.get(target);
    }

    public void addIncoming(SSEdge e) {
        this.incoming.put(e.getSource(), e);
    }

    public void addOutgoing(SSEdge e) {
        this.outgoing.put(e.getTarget(), e);
    }

    public SSVertex(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public int compareTo(SSVertex other) {
        return Integer.compare(this.id, other.id);
    }
}

