/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph.simple_double;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.graph.DoubleWeightedGraph;
import org.eclipse.lsat.common.ludus.backend.graph.simple_double.SDEdge;
import org.eclipse.lsat.common.ludus.backend.graph.simple_double.SDVertex;

public class SDGraph
implements DoubleWeightedGraph<SDVertex, SDEdge, Double> {
    private static final long serialVersionUID = 1L;
    private final Set<SDVertex> vertexSet = new HashSet<SDVertex>();
    private final Set<SDEdge> edgeSet = new HashSet<SDEdge>();

    @Override
    public Set<SDEdge> getEdges() {
        return this.edgeSet;
    }

    public void addVertex(SDVertex vertex) {
        this.vertexSet.add(vertex);
    }

    public SDEdge addEdge(SDVertex source, SDVertex target, Double w1, Double w2) {
        SDEdge e = new SDEdge(source, target, w1, w2);
        source.addOutgoing(e);
        target.addIncoming(e);
        this.edgeSet.add(e);
        return e;
    }

    @Override
    public Set<SDVertex> getVertices() {
        return this.vertexSet;
    }

    @Override
    public Collection<SDEdge> incomingEdgesOf(SDVertex v) {
        return v.getIncoming();
    }

    @Override
    public Collection<SDEdge> outgoingEdgesOf(SDVertex v) {
        return v.getOutgoing();
    }

    @Override
    public SDVertex getEdgeSource(SDEdge e) {
        return e.getSource();
    }

    @Override
    public SDVertex getEdgeTarget(SDEdge e) {
        return e.getTarget();
    }

    @Override
    public SDEdge getEdge(SDVertex source, SDVertex target) {
        return source.getOutgoing(target);
    }

    @Override
    public Double getWeight1(SDEdge edge) {
        return edge.getWeight1();
    }

    @Override
    public Double getWeight2(SDEdge edge) {
        return edge.getWeight2();
    }
}

