/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.graph;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.graph.Graph;

public class DFS<V, E, R> {
    Graph<V, E> graph;
    V startVertex;
    R visitedResult;
    Map<Object, Boolean> statusMap = new HashMap<Object, Boolean>();

    public R execute(Graph<V, E> graph, V startVertex) {
        this.graph = graph;
        this.startVertex = startVertex;
        for (V v : graph.getVertices()) {
            this.unvisit(v);
        }
        for (Object e : graph.getEdges()) {
            this.unvisit(e);
        }
        this.setup();
        return this.finalResult(this.dfsTraversal(startVertex));
    }

    protected R dfsTraversal(V v) {
        this.initResult();
        if (!this.isDone()) {
            this.startVisit(v);
        }
        if (!this.isDone()) {
            this.visit(v);
            for (E e : this.graph.outgoingEdgesOf(v)) {
                if (this.isVisited(e)) continue;
                this.visit(e);
                V w = this.graph.getEdgeTarget(e);
                if (!this.isVisited(w)) {
                    this.traverseDiscovery(e, v);
                    if (this.isDone()) break;
                    this.visitedResult = this.dfsTraversal(w);
                    if (!this.isDone()) continue;
                    break;
                }
                this.traverseBack(e, v);
                if (this.isDone()) break;
            }
        }
        if (!this.isDone()) {
            this.finishVisit(v);
        }
        return this.result();
    }

    protected void visit(Object o) {
        this.statusMap.put(o, true);
    }

    protected void unvisit(Object o) {
        this.statusMap.put(o, false);
    }

    protected boolean isVisited(Object o) {
        return this.statusMap.get(o);
    }

    protected void setup() {
    }

    protected void initResult() {
    }

    protected void startVisit(V v) {
    }

    protected void finishVisit(V v) {
    }

    protected void traverseDiscovery(E e, V from) {
    }

    protected void traverseBack(E e, V from) {
    }

    protected boolean isDone() {
        return false;
    }

    protected R result() {
        return null;
    }

    protected R finalResult(R r) {
        return r;
    }
}

