/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.algorithms;

public class DoubleFunctions {
    public static final double EPSILON = 1.0E-4;
    public static final double DELTA = 1.0E-4;
    public static final double MACHINE_PRECISION = 1.0E-12;

    private DoubleFunctions() {
    }

    public static boolean equalTo(double a, double b) {
        return a == b || Math.abs(a - b) < 1.0E-4;
    }

    public static boolean equalTo(double a, double b, double epsilon) {
        return a == b || Math.abs(a - b) < epsilon;
    }

    public static boolean nearlyEqual(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || diff < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Double.MAX_VALUE) < epsilon;
    }

    public static boolean greaterThan(double a, double b) {
        return DoubleFunctions.greaterThan(a, b, 1.0E-4);
    }

    public static boolean greaterThan(double a, double b, double epsilon) {
        return a - b > epsilon;
    }

    public static boolean lessThan(double a, double b) {
        return DoubleFunctions.lessThan(a, b, 1.0E-4);
    }

    public static boolean lessThan(double a, double b, double epsilon) {
        return b - a > epsilon;
    }
}

