/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algebra;

import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;

public class DenseMatrix
extends Matrix {
    private int columns;
    private int rows;
    private Value[][] matrix;

    public DenseMatrix(int rows, int columns) {
        this.columns = columns;
        this.rows = rows;
        this.matrix = new Value[rows][columns];
    }

    public DenseMatrix(int rows, int columns, Double ... values) {
        this.columns = columns;
        this.rows = rows;
        this.matrix = new Value[rows][columns];
        int i = 0;
        Double[] doubleArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Double val = doubleArray[n2];
            this.put(i / this.getColumns(), i % this.getRows(), new Value(val));
            ++i;
            ++n2;
        }
    }

    @Override
    public void put(int row, int column, Value value) {
        this.matrix[row][column] = value;
    }

    @Override
    public Value get(int row, int column) {
        if (this.matrix[row][column] != null) {
            return this.matrix[row][column];
        }
        if (row == column) {
            return new Value(0.0);
        }
        return Value.NEGATIVE_INFINITY;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.rows) {
            sb.append("| ");
            int j = 0;
            while (j < this.columns) {
                sb.append(this.get(i, j).toString());
                sb.append("\t");
                ++j;
            }
            sb.append("|\n");
            ++i;
        }
        return sb.toString();
    }
}

