/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.ui.AnalysisUtil;
import org.eclipse.trace4cps.ui.ConsoleUtil;
import org.eclipse.trace4cps.ui.dialog.DistanceDialog;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class DistanceAction
extends AbstractTraceViewAction {
    public DistanceAction(TraceView view) {
        super(view);
        this.setText("Order analysis");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() > 1 && this.view.hasEvents(true, true);
    }

    @Override
    protected void doRun() throws TraceException {
        if (this.view.getNumTraces() == 2) {
            HashMap<IAttributeAware, Paint> highlight = new HashMap<IAttributeAware, Paint>();
            this.computeDistance(highlight, this.view.getTrace(0), this.view.getTrace(1));
            this.viewCfg.setHighlightMap(highlight);
        } else {
            HashMap<String, Integer> traceKeyToIndex = new HashMap<String, Integer>();
            int i = 0;
            while (i < this.view.getNumTraces()) {
                ITrace trace = this.view.getTrace(i);
                traceKeyToIndex.put(TraceHelper.getValues((IAttributeAware)trace, (boolean)false), i);
                ++i;
            }
            DistanceDialog dialog = new DistanceDialog(this.view.getEditorSite().getShell(), traceKeyToIndex);
            if (dialog.open() == 0) {
                int refIdx = dialog.getReferenceIndex();
                ITrace[] modelTraces = new ITrace[this.view.getNumTraces() - 1];
                int i2 = 0;
                int j = 0;
                while (i2 < this.view.getNumTraces()) {
                    if (i2 != refIdx) {
                        modelTraces[j] = this.view.getTrace(i2);
                        ++j;
                    }
                    ++i2;
                }
                HashMap<IAttributeAware, Paint> highlight = new HashMap<IAttributeAware, Paint>();
                ITrace reference = this.view.getTrace(refIdx);
                ITrace[] iTraceArray = modelTraces;
                int n = modelTraces.length;
                int n2 = 0;
                while (n2 < n) {
                    ITrace modelTrace = iTraceArray[n2];
                    this.computeDistance(highlight, reference, modelTrace);
                    ++n2;
                }
                this.viewCfg.setHighlightMap(highlight);
            }
        }
        this.view.update();
    }

    private void computeDistance(Map<IAttributeAware, Paint> highlight, ITrace reference, ITrace modelTrace) {
        long dist = AnalysisUtil.computeDiffHighlights(reference, modelTrace, false, highlight);
        ConsoleUtil.log("Distance from " + TraceHelper.getValues((IAttributeAware)reference, (boolean)false) + " to " + TraceHelper.getValues((IAttributeAware)modelTrace, (boolean)false) + " : " + dist);
    }
}

