/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class EclipseSelectionWrapper
implements IPropertySource {
    private static final String ATTS = "Attributes";
    private static final String CLAIM_ATTS = "Claim attributes";
    private static final String EVENT_ATTS = "Event attributes";
    private static final String DEP_ATTS = "Dependency attributes";
    private static final String SIGNAL_ATTS = "Signal attributes";
    private static final String FRAGMENT = "Fragment properties";
    private static final String CLAIM = "Claim properties";
    private static final String EVENT = "Event properties";
    private static final String DEPENDENCY = "Dependency properties";
    private static final String RESOURCE = "Resource properties";
    private static final String RESOURCE_ATTS = "Resource attributes";
    private final Map<String, Map<String, String>> catProps = new HashMap<String, Map<String, String>>();
    private final Map<String, String> id2Value = new HashMap<String, String>();
    private final Object item;

    public EclipseSelectionWrapper(IPsop psop, IPsopFragment item) {
        this.item = item;
        this.addAttributes(SIGNAL_ATTS, (IAttributeAware)psop);
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        p.put("start time", item.dom().lb().toString());
        p.put("end time", item.dom().ub().toString());
        p.put("duration", Double.toString(item.dom().ub().doubleValue() - item.dom().lb().doubleValue()));
        p.put("a", item.getA().toString());
        p.put("b", item.getB().toString());
        p.put("c", item.getC().toString());
        p.put("shape", item.getShape().toString());
        this.catProps.put(FRAGMENT, p);
    }

    public EclipseSelectionWrapper(IAttributeAware item) {
        this.item = item;
        if (item instanceof IClaim) {
            IClaim claim = (IClaim)item;
            this.addAttributes(CLAIM_ATTS, (IAttributeAware)claim);
            LinkedHashMap<String, String> claimProps = new LinkedHashMap<String, String>();
            claimProps.put("start time", Double.toString(claim.getStartTime().doubleValue()));
            claimProps.put("end time", Double.toString(claim.getEndTime().doubleValue()));
            claimProps.put("duration", Double.toString(claim.getEndTime().doubleValue() - claim.getStartTime().doubleValue()));
            claimProps.put("amount", claim.getAmount().toString());
            if (claim.getResource().useOffset()) {
                claimProps.put("offset", claim.getOffset().toString());
            }
            this.catProps.put(CLAIM, claimProps);
            this.addAttributes(RESOURCE_ATTS, (IAttributeAware)claim.getResource());
            LinkedHashMap<String, String> resProps = new LinkedHashMap<String, String>();
            resProps.put("uses offset", Boolean.toString(claim.getResource().useOffset()));
            resProps.put("capacity", claim.getResource().getCapacity().toString());
            this.catProps.put(RESOURCE, resProps);
        } else if (item instanceof IEvent) {
            IEvent event = (IEvent)item;
            this.addAttributes(EVENT_ATTS, (IAttributeAware)event);
            LinkedHashMap<String, String> eventProps = new LinkedHashMap<String, String>();
            eventProps.put("start time", Double.toString(event.getTimestamp().doubleValue()));
            this.catProps.put(EVENT, eventProps);
        } else if (item instanceof IDependency) {
            IDependency dep = (IDependency)item;
            this.addAttributes(DEP_ATTS, (IAttributeAware)dep);
            LinkedHashMap<String, String> depProps = new LinkedHashMap<String, String>();
            depProps.put("start time", dep.getSrc().getTimestamp().toString());
            depProps.put("end time", dep.getDst().getTimestamp().toString());
            depProps.put("duration", Double.toString(dep.getDst().getTimestamp().doubleValue() - dep.getSrc().getTimestamp().doubleValue()));
            this.catProps.put(DEPENDENCY, depProps);
        } else {
            this.addAttributes(ATTS, item);
        }
    }

    public Object getSelectedTraceItem() {
        return this.item;
    }

    private void addAttributes(String cat, IAttributeAware a) {
        TreeMap atts = new TreeMap();
        atts.putAll(a.getAttributes());
        this.catProps.put(cat, atts);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<ClaimPropertyDescriptor> r = new ArrayList<ClaimPropertyDescriptor>();
        for (Map.Entry<String, Map<String, String>> e : this.catProps.entrySet()) {
            String cat = e.getKey();
            for (Map.Entry<String, String> e2 : e.getValue().entrySet()) {
                String id = String.valueOf(cat) + "_" + e2.getKey();
                r.add(new ClaimPropertyDescriptor(cat, id, e2.getKey()));
                this.id2Value.put(id, e2.getValue());
            }
        }
        return r.toArray(new IPropertyDescriptor[r.size()]);
    }

    public Object getPropertyValue(Object id) {
        return this.id2Value.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static final class ClaimPropertyDescriptor
    extends PropertyDescriptor {
        public ClaimPropertyDescriptor(String cat, String id, String displayName) {
            super((Object)id, displayName);
            this.setCategory(cat);
            this.setAlwaysIncompatible(true);
        }
    }
}

