/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.viewers;

import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeSeriesCollection;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceProvider;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.annotations.Annotation;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.ohlc.OHLCSeriesCollection;
import org.jfree.data.xy.VectorSeriesCollection;
import org.jfree.data.xy.XIntervalSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeriesCollection;

public class BackReferenceResolver {
    public static final BackReferenceResolver DEFAULT = new BackReferenceResolver();

    public BackReferenceProvider<?> resolveBackReferenceProvider(ChartMouseEvent event) {
        return this.resolveBackReferenceProvider(event.getEntity());
    }

    public BackReferenceProvider<?> resolveBackReferenceProvider(ChartEntity chartEntity) {
        return this.doResolveBackReferenceProvider(chartEntity);
    }

    public BackReferenceProvider<?> resolveBackReferenceProvider(Annotation annotation) {
        return this.doResolveBackReferenceProvider(annotation);
    }

    public BackReferenceProvider<?> resolveBackReferenceProvider(XYDataset dataset, int series, int item) {
        return this.doResolveBackReferenceProvider(this.resolveDataItem(dataset, series, item));
    }

    protected BackReferenceProvider<?> doResolveBackReferenceProvider(Object o) {
        CategoryItemEntity entity;
        BackReferenceProvider<?> backReferenceProvider = null;
        if (o instanceof BackReferenceProvider) {
            backReferenceProvider = (BackReferenceProvider<?>)o;
        } else if (o instanceof XYItemEntity) {
            XYItemEntity entity2 = (XYItemEntity)o;
            backReferenceProvider = this.resolveBackReferenceProvider(entity2.getDataset(), entity2.getSeriesIndex(), entity2.getItem());
        } else if (o instanceof PieSectionEntity) {
            PieSectionEntity entity3 = (PieSectionEntity)o;
            backReferenceProvider = this.doResolveBackReferenceProvider(entity3.getSectionKey());
        } else if (o instanceof CategoryItemEntity && (backReferenceProvider = this.doResolveBackReferenceProvider((entity = (CategoryItemEntity)o).getColumnKey())) == null) {
            backReferenceProvider = this.doResolveBackReferenceProvider(entity.getRowKey());
        }
        return backReferenceProvider;
    }

    protected Object resolveDataItem(XYDataset dataset, int series, int item) {
        if (series >= dataset.getSeriesCount() || item >= dataset.getItemCount(series)) {
            return null;
        }
        if (dataset instanceof XYIntervalSeriesCollection) {
            return ((XYIntervalSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof XYSeriesCollection) {
            return ((XYSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof XYEdgeSeriesCollection) {
            return ((XYEdgeSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof XIntervalSeriesCollection) {
            return ((XIntervalSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof YIntervalSeriesCollection) {
            return ((YIntervalSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof OHLCSeriesCollection) {
            return ((OHLCSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof TimePeriodValuesCollection) {
            return ((TimePeriodValuesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof TimeSeriesCollection) {
            return ((TimeSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        if (dataset instanceof VectorSeriesCollection) {
            return ((VectorSeriesCollection)dataset).getSeries(series).getDataItem(item);
        }
        return null;
    }
}

