/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.gantt;

import java.math.BigDecimal;
import org.eclipse.trace4cps.common.jfreechart.ui.gantt.XYGanttDataItem;
import org.eclipse.trace4cps.common.jfreechart.ui.gantt.XYGanttMeasurement;
import org.eclipse.trace4cps.common.jfreechart.ui.gantt.XYGanttMeasurementAnnotationDescriptor;
import org.eclipse.trace4cps.common.jfreechart.ui.viewers.BackReferenceProvider;
import org.jfree.chart.annotations.XYMeasurementAnnotation;

public class XYGanttMeasurementAnnotation<T>
extends XYMeasurementAnnotation
implements XYGanttMeasurement<T>,
BackReferenceProvider<XYGanttMeasurementAnnotationDescriptor<T>> {
    private static final long serialVersionUID = -5836943007613577145L;
    private final XYGanttMeasurementAnnotationDescriptor<T> descriptor = new XYGanttMeasurementAnnotationDescriptor(this);
    private final XYGanttDataItem<? extends T> item1;
    private final XYGanttMeasurement.Snap snap1;
    private final XYGanttDataItem<? extends T> item2;
    private final XYGanttMeasurement.Snap snap2;

    public XYGanttMeasurementAnnotation(XYMeasurementAnnotation.Orientation orientation, String label, XYGanttDataItem<? extends T> item1, XYGanttMeasurement.Snap snap1, XYGanttDataItem<? extends T> item2, XYGanttMeasurement.Snap snap2) {
        super(orientation, label, snap1 == XYGanttMeasurement.Snap.START ? item1.getXLowValue() : item1.getXHighValue(), item1.getYValue(), snap2 == XYGanttMeasurement.Snap.START ? item2.getXLowValue() : item2.getXHighValue(), item2.getYValue());
        this.setBaseCreateEntity(true);
        this.item1 = item1;
        this.snap1 = snap1;
        this.item2 = item2;
        this.snap2 = snap2;
    }

    @Override
    public XYGanttMeasurementAnnotationDescriptor<T> getBackReference() {
        return this.descriptor;
    }

    @Override
    public T getBackReference1() {
        return this.item1.getBackReference();
    }

    @Override
    public T getBackReference2() {
        return this.item2.getBackReference();
    }

    @Override
    public XYGanttMeasurement.Snap getSnap1() {
        return this.snap1;
    }

    @Override
    public XYGanttMeasurement.Snap getSnap2() {
        return this.snap2;
    }

    @Override
    public Number getTime1() {
        return this.getX();
    }

    @Override
    public Number getTime2() {
        return this.getX2();
    }

    @Override
    public Number getDuration() {
        return BigDecimal.valueOf(this.getX2()).subtract(BigDecimal.valueOf(this.getX())).abs();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.item1 == null ? 0 : this.item1.hashCode());
        result = 31 * result + (this.item2 == null ? 0 : this.item2.hashCode());
        result = 31 * result + (this.snap1 == null ? 0 : this.snap1.hashCode());
        result = 31 * result + (this.snap2 == null ? 0 : this.snap2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYGanttMeasurementAnnotation other = (XYGanttMeasurementAnnotation)obj;
        if (this.item1 == null ? other.item1 != null : !this.item1.equals(other.item1)) {
            return false;
        }
        if (this.item2 == null ? other.item2 != null : !this.item2.equals(other.item2)) {
            return false;
        }
        if (this.snap1 != other.snap1) {
            return false;
        }
        return this.snap2 == other.snap2;
    }
}

