/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifInvariantUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class RemoveRequirements
implements CifToCifTransformation {
    public boolean removeReqAuts = true;
    public boolean removeStateEvtExclReqInvs = true;
    public boolean removeStateReqInvs = true;
    private Map<Automaton, String> absReqAutNames;

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Removing requirements from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.absReqAutNames = Maps.map();
        this.removeRequirements((ComplexComponent)spec);
        this.checkRefs(spec);
    }

    private void removeRequirements(ComplexComponent comp) {
        SupKind kind;
        Iterator invIter = comp.getInvariants().iterator();
        while (invIter.hasNext()) {
            Invariant inv = (Invariant)invIter.next();
            SupKind kind2 = CifInvariantUtils.getSupKind((Invariant)inv);
            if (kind2 != SupKind.REQUIREMENT) continue;
            switch (inv.getInvKind()) {
                case STATE: {
                    if (!this.removeStateReqInvs) break;
                    invIter.remove();
                    break;
                }
                case EVENT_NEEDS: 
                case EVENT_DISABLES: {
                    if (!this.removeStateEvtExclReqInvs) break;
                    invIter.remove();
                }
            }
        }
        if (comp instanceof Group) {
            EList children = ((Group)comp).getComponents();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                Component child = (Component)childIter.next();
                if (child instanceof Automaton && (kind = ((Automaton)child).getKind()) == SupKind.REQUIREMENT && this.removeReqAuts) {
                    this.absReqAutNames.put((Automaton)child, CifTextUtils.getAbsName((PositionObject)child));
                    childIter.remove();
                    continue;
                }
                this.removeRequirements((ComplexComponent)child);
            }
        }
        if (comp instanceof Automaton) {
            for (Location loc : ((Automaton)comp).getLocations()) {
                invIter = loc.getInvariants().iterator();
                while (invIter.hasNext()) {
                    Invariant inv = (Invariant)invIter.next();
                    kind = CifInvariantUtils.getSupKind((Invariant)inv);
                    if (kind != SupKind.REQUIREMENT) continue;
                    switch (inv.getInvKind()) {
                        case STATE: {
                            if (!this.removeStateReqInvs) break;
                            invIter.remove();
                            break;
                        }
                        case EVENT_NEEDS: 
                        case EVENT_DISABLES: {
                            if (!this.removeStateEvtExclReqInvs) break;
                            invIter.remove();
                        }
                    }
                }
            }
        }
    }

    private void checkRefs(Specification spec) {
        Map problems = EcoreUtil.ExternalCrossReferencer.find((EObject)spec);
        if (problems.isEmpty()) {
            return;
        }
        Set messages = Sets.set();
        for (Map.Entry problem : problems.entrySet()) {
            String relTxt;
            PositionObject removedObj = (PositionObject)problem.getKey();
            Collection problemRefs = (Collection)problem.getValue();
            EObject removedRootObj = EcoreUtil.getRootContainer((EObject)removedObj);
            Automaton removedReqAut = (Automaton)removedRootObj;
            String absReqName = this.absReqAutNames.get(removedReqAut);
            Assert.notNull((Object)absReqName);
            if (removedReqAut == removedObj) {
                relTxt = null;
            } else {
                PositionObject scope = CifScopeUtils.getScope((PositionObject)removedObj);
                Assert.check((scope == removedReqAut ? 1 : 0) != 0);
                relTxt = CifTextUtils.getName((PositionObject)removedObj);
                relTxt = CifTextUtils.escapeIdentifier((String)relTxt);
            }
            for (EStructuralFeature.Setting problemRef : problemRefs) {
                PositionObject refObj = (PositionObject)problemRef.getEObject();
                PositionObject scope = CifScopeUtils.isScope((PositionObject)refObj) ? refObj : CifScopeUtils.getScope((PositionObject)refObj);
                ComplexComponent scopeComp = (ComplexComponent)scope;
                String scopeTxt = CifTextUtils.getComponentText2((ComplexComponent)scopeComp);
                String declTxt = relTxt == null ? "" : Strings.fmt((String)"contains declaration \"%s\" that ", (Object[])new Object[]{relTxt});
                String msg = Strings.fmt((String)"Requirement automaton \"%s\" %sis used somewhere in %s.", (Object[])new Object[]{absReqName, declTxt, scopeTxt});
                messages.add(msg);
            }
        }
        String msg = "Removing requirements from a CIF specification failed due to the remaining part of the specification using declarations that are declared in the requirement automata that are to be removed:\n - " + StringUtils.join((Collection)Sets.sortedstrings((Set)messages), (String)"\n - ");
        throw new CifToCifPreconditionException(msg);
    }
}

