/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.TextEdit;

public class RenameAnalyzeUtil {
    private RenameAnalyzeUtil() {
    }

    public static RefactoringStatus analyzeRenameChanges(TextChangeManager manager, SearchResultGroup[] oldOccurrences, SearchResultGroup[] newOccurrences) {
        RefactoringStatus result = new RefactoringStatus();
        SearchResultGroup[] searchResultGroupArray = oldOccurrences;
        int n = oldOccurrences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup oldGroup = searchResultGroupArray[n2];
            SearchMatch[] oldSearchResults = oldGroup.getSearchResults();
            ICompilationUnit cunit = oldGroup.getCompilationUnit();
            if (cunit != null) {
                SearchMatch[] searchMatchArray = oldSearchResults;
                int n3 = oldSearchResults.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch oldSearchResult = searchMatchArray[n4];
                    if (!RenameAnalyzeUtil.existsInNewOccurrences(oldSearchResult, newOccurrences, manager)) {
                        RenameAnalyzeUtil.addShadowsError(cunit, oldSearchResult, result);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public static ICompilationUnit findWorkingCopyForCu(ICompilationUnit[] newWorkingCopies, ICompilationUnit cu) {
        ICompilationUnit original = cu == null ? null : cu.getPrimary();
        ICompilationUnit[] iCompilationUnitArray = newWorkingCopies;
        int n = newWorkingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit newWorkingCopy = iCompilationUnitArray[n2];
            if (newWorkingCopy.getPrimary().equals(original)) {
                return newWorkingCopy;
            }
            ++n2;
        }
        return null;
    }

    public static ICompilationUnit[] createNewWorkingCopies(ICompilationUnit[] compilationUnitsToModify, TextChangeManager manager, WorkingCopyOwner owner, SubProgressMonitor pm) throws CoreException {
        pm.beginTask("", compilationUnitsToModify.length);
        ICompilationUnit[] newWorkingCopies = new ICompilationUnit[compilationUnitsToModify.length];
        int i = 0;
        while (i < compilationUnitsToModify.length) {
            ICompilationUnit cu = compilationUnitsToModify[i];
            newWorkingCopies[i] = RenameAnalyzeUtil.createNewWorkingCopy(cu, manager, owner, new SubProgressMonitor((IProgressMonitor)pm, 1));
            ++i;
        }
        pm.done();
        return newWorkingCopies;
    }

    public static ICompilationUnit createNewWorkingCopy(ICompilationUnit cu, TextChangeManager manager, WorkingCopyOwner owner, SubProgressMonitor pm) throws CoreException {
        ICompilationUnit newWc = cu.getWorkingCopy(owner, null);
        String previewContent = manager.get(cu).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        newWc.getBuffer().setContents(previewContent);
        newWc.reconcile(0, false, owner, (IProgressMonitor)pm);
        return newWc;
    }

    private static boolean existsInNewOccurrences(SearchMatch searchResult, SearchResultGroup[] newOccurrences, TextChangeManager manager) {
        SearchResultGroup newGroup = RenameAnalyzeUtil.findOccurrenceGroup(searchResult.getResource(), newOccurrences);
        if (newGroup == null) {
            return false;
        }
        IRegion oldEditRange = RenameAnalyzeUtil.getCorrespondingEditChangeRange(searchResult, manager);
        if (oldEditRange == null) {
            return false;
        }
        int oldRangeOffset = oldEditRange.getOffset();
        SearchMatch[] searchMatchArray = newGroup.getSearchResults();
        int n = searchMatchArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchMatch newSearchResult = searchMatchArray[n2];
            if (newSearchResult.getOffset() == oldRangeOffset) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IRegion getCorrespondingEditChangeRange(SearchMatch searchResult, TextChangeManager manager) {
        TextChange change = RenameAnalyzeUtil.getTextChange(searchResult, manager);
        if (change == null) {
            return null;
        }
        IRegion oldMatchRange = RenameAnalyzeUtil.createTextRange(searchResult);
        TextEditChangeGroup[] textEditChangeGroupArray = change.getTextEditChangeGroups();
        int n = textEditChangeGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditChangeGroup editChange = textEditChangeGroupArray[n2];
            if (oldMatchRange.equals(editChange.getRegion())) {
                return TextEdit.getCoverage((TextEdit[])change.getPreviewEdits(editChange.getTextEdits()));
            }
            ++n2;
        }
        return null;
    }

    private static TextChange getTextChange(SearchMatch searchResult, TextChangeManager manager) {
        ICompilationUnit cu = SearchUtils.getCompilationUnit(searchResult);
        if (cu == null) {
            return null;
        }
        return manager.get(cu);
    }

    private static IRegion createTextRange(SearchMatch searchResult) {
        return new Region(searchResult.getOffset(), searchResult.getLength());
    }

    private static SearchResultGroup findOccurrenceGroup(IResource resource, SearchResultGroup[] newOccurrences) {
        SearchResultGroup[] searchResultGroupArray = newOccurrences;
        int n = newOccurrences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup newOccurrence = searchResultGroupArray[n2];
            if (newOccurrence.getResource().equals((Object)resource)) {
                return newOccurrence;
            }
            ++n2;
        }
        return null;
    }

    public static RefactoringStatus analyzeRenameChanges2(TextChangeManager manager, SearchResultGroup[] oldReferences, SearchResultGroup[] newReferences, String newElementName) {
        RefactoringStatus result = new RefactoringStatus();
        HashMap<ICompilationUnit, SearchMatch[]> cuToNewResults = new HashMap<ICompilationUnit, SearchMatch[]>(newReferences.length);
        SearchResultGroup[] searchResultGroupArray = newReferences;
        int n = newReferences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup newReference = searchResultGroupArray[n2];
            ICompilationUnit cu = newReference.getCompilationUnit();
            if (cu != null) {
                cuToNewResults.put(cu.getPrimary(), newReference.getSearchResults());
            }
            ++n2;
        }
        searchResultGroupArray = oldReferences;
        n = oldReferences.length;
        n2 = 0;
        while (n2 < n) {
            SearchResultGroup oldGroup = searchResultGroupArray[n2];
            SearchMatch[] oldMatches = oldGroup.getSearchResults();
            ICompilationUnit cu = oldGroup.getCompilationUnit();
            if (cu != null) {
                SearchMatch[] newSearchMatches = (SearchMatch[])cuToNewResults.remove(cu);
                if (newSearchMatches == null) {
                    SearchMatch[] searchMatchArray = oldMatches;
                    int n3 = oldMatches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SearchMatch oldMatch = searchMatchArray[n4];
                        RenameAnalyzeUtil.addShadowsError(cu, oldMatch, result);
                        ++n4;
                    }
                } else {
                    RenameAnalyzeUtil.analyzeChanges(cu, manager.get(cu), oldMatches, newSearchMatches, newElementName, result);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : cuToNewResults.entrySet()) {
            ICompilationUnit cu = (ICompilationUnit)entry.getKey();
            SearchMatch[] searchMatchArray = (SearchMatch[])entry.getValue();
            int n5 = searchMatchArray.length;
            int n6 = 0;
            while (n6 < n5) {
                SearchMatch newMatch = searchMatchArray[n6];
                RenameAnalyzeUtil.addReferenceShadowedError(cu, newMatch, newElementName, result);
                ++n6;
            }
        }
        return result;
    }

    private static void analyzeChanges(ICompilationUnit cu, TextChange change, SearchMatch[] oldMatches, SearchMatch[] newMatches, String newElementName, RefactoringStatus result) {
        Map<Integer, SearchMatch> updatedOldOffsets = RenameAnalyzeUtil.getUpdatedChangeOffsets(change, oldMatches);
        SearchMatch[] searchMatchArray = newMatches;
        int n = newMatches.length;
        int n2 = 0;
        while (n2 < n) {
            SearchMatch newMatch = searchMatchArray[n2];
            Integer offsetInNew = newMatch.getOffset();
            SearchMatch oldMatch = updatedOldOffsets.remove(offsetInNew);
            if (oldMatch == null) {
                RenameAnalyzeUtil.addReferenceShadowedError(cu, newMatch, newElementName, result);
            }
            ++n2;
        }
        for (SearchMatch oldMatch : updatedOldOffsets.values()) {
            RenameAnalyzeUtil.addShadowsError(cu, oldMatch, result);
        }
    }

    private static Map<Integer, SearchMatch> getUpdatedChangeOffsets(TextChange change, SearchMatch[] oldMatches) {
        HashMap<Integer, SearchMatch> updatedOffsets = new HashMap<Integer, SearchMatch>();
        Map<Integer, Integer> oldToUpdatedOffsets = RenameAnalyzeUtil.getEditChangeOffsetUpdates(change);
        SearchMatch[] searchMatchArray = oldMatches;
        int n = oldMatches.length;
        int n2 = 0;
        while (n2 < n) {
            SearchMatch oldMatch = searchMatchArray[n2];
            Integer updatedOffset = oldToUpdatedOffsets.get(oldMatch.getOffset());
            if (updatedOffset == null) {
                updatedOffset = -1;
            }
            updatedOffsets.put(updatedOffset, oldMatch);
            ++n2;
        }
        return updatedOffsets;
    }

    private static Map<Integer, Integer> getEditChangeOffsetUpdates(TextChange change) {
        TextEditChangeGroup[] editChanges = change.getTextEditChangeGroups();
        HashMap<Integer, Integer> offsetUpdates = new HashMap<Integer, Integer>(editChanges.length);
        TextEditChangeGroup[] textEditChangeGroupArray = editChanges;
        int n = editChanges.length;
        int n2 = 0;
        while (n2 < n) {
            IRegion updatedRegion;
            TextEditChangeGroup editChange = textEditChangeGroupArray[n2];
            IRegion oldRegion = editChange.getRegion();
            if (oldRegion != null && (updatedRegion = TextEdit.getCoverage((TextEdit[])change.getPreviewEdits(editChange.getTextEdits()))) != null) {
                offsetUpdates.put(oldRegion.getOffset(), updatedRegion.getOffset());
            }
            ++n2;
        }
        return offsetUpdates;
    }

    private static void addReferenceShadowedError(ICompilationUnit cu, SearchMatch newMatch, String newElementName, RefactoringStatus result) {
        if (newMatch instanceof MethodDeclarationMatch || newMatch instanceof FieldDeclarationMatch) {
            return;
        }
        ISourceRange range = RenameAnalyzeUtil.getOldSourceRange(newMatch);
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)cu, range);
        String message = Messages.format(RefactoringCoreMessages.RenameAnalyzeUtil_reference_shadowed, new String[]{BasicElementLabels.getFileName((ITypeRoot)cu), BasicElementLabels.getJavaElementName(newElementName)});
        result.addError(message, context);
    }

    private static ISourceRange getOldSourceRange(SearchMatch newMatch) {
        IJavaElement newMatchElement = (IJavaElement)newMatch.getElement();
        IJavaElement primaryElement = newMatchElement.getPrimaryElement();
        ISourceRange range = null;
        if (primaryElement.exists() && primaryElement instanceof ISourceReference) {
            try {
                range = ((ISourceReference)primaryElement).getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
        }
        return range;
    }

    private static void addShadowsError(ICompilationUnit cu, SearchMatch oldMatch, RefactoringStatus result) {
        if (oldMatch instanceof MethodDeclarationMatch || oldMatch instanceof FieldDeclarationMatch) {
            return;
        }
        SourceRange range = new SourceRange(oldMatch.getOffset(), oldMatch.getLength());
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)cu, (ISourceRange)range);
        String message = Messages.format(RefactoringCoreMessages.RenameAnalyzeUtil_shadows, BasicElementLabels.getFileName((ITypeRoot)cu));
        result.addError(message, context);
    }

    public static RefactoringStatus analyzeLocalRenames(LocalAnalyzePackage[] analyzePackages, TextChange cuChange, CompilationUnit oldCUNode, boolean recovery) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        ICompilationUnit compilationUnit = (ICompilationUnit)oldCUNode.getJavaElement();
        String newCuSource = cuChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit newCUNode = new RefactoringASTParser(14).parse(newCuSource, compilationUnit, true, recovery, null);
        result.merge(RenameAnalyzeUtil.analyzeCompileErrors(newCuSource, newCUNode, oldCUNode));
        if (result.hasError()) {
            return result;
        }
        LocalAnalyzePackage[] localAnalyzePackageArray = analyzePackages;
        int n = analyzePackages.length;
        int n2 = 0;
        while (n2 < n) {
            LocalAnalyzePackage analyzePackage = localAnalyzePackageArray[n2];
            ASTNode enclosing = RenameAnalyzeUtil.getEnclosingBlockOrMethodOrLambda(analyzePackage.fDeclarationEdit, cuChange, newCUNode);
            IRegion newRegion = RefactoringAnalyzeUtil.getNewTextRange(analyzePackage.fDeclarationEdit, cuChange);
            ASTNode newDeclaration = NodeFinder.perform((ASTNode)newCUNode, (int)newRegion.getOffset(), (int)newRegion.getLength());
            Assert.isTrue((boolean)(newDeclaration instanceof Name));
            VariableDeclaration declaration = RenameAnalyzeUtil.getVariableDeclaration((Name)newDeclaration);
            Assert.isNotNull((Object)declaration);
            SimpleName[] problemNodes = ProblemNodeFinder.getProblemNodes(enclosing, declaration, analyzePackage.fOccurenceEdits, cuChange);
            result.merge(RefactoringAnalyzeUtil.reportProblemNodes(newCuSource, problemNodes));
            ++n2;
        }
        return result;
    }

    private static VariableDeclaration getVariableDeclaration(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding == null && node.getParent() instanceof VariableDeclaration) {
            return (VariableDeclaration)node.getParent();
        }
        if (binding != null && binding.getKind() == 3) {
            CompilationUnit cu = ASTNodes.getParent((ASTNode)node, CompilationUnit.class);
            return ASTNodes.findVariableDeclaration((IVariableBinding)binding, (ASTNode)cu);
        }
        return null;
    }

    private static ASTNode getEnclosingBlockOrMethodOrLambda(TextEdit declarationEdit, TextChange change, CompilationUnit newCUNode) {
        Block enclosing = RefactoringAnalyzeUtil.getBlock(declarationEdit, change, newCUNode);
        if (enclosing == null) {
            enclosing = RefactoringAnalyzeUtil.getMethodDeclaration(declarationEdit, change, newCUNode);
        }
        if (enclosing == null) {
            enclosing = RefactoringAnalyzeUtil.getLambdaExpression(declarationEdit, change, newCUNode);
        }
        return enclosing;
    }

    private static RefactoringStatus analyzeCompileErrors(String newCuSource, CompilationUnit newCUNode, CompilationUnit oldCUNode) {
        RefactoringStatus result = new RefactoringStatus();
        IProblem[] iProblemArray = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCUNode, oldCUNode);
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                result.addEntry(new RefactoringStatusEntry(problem.isError() ? 3 : 2, problem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(newCuSource, SourceRangeFactory.create(problem))));
            }
            ++n2;
        }
        return result;
    }

    public static class LocalAnalyzePackage {
        public final TextEdit fDeclarationEdit;
        public final TextEdit[] fOccurenceEdits;

        public LocalAnalyzePackage(TextEdit declarationEdit, TextEdit[] occurenceEdits) {
            this.fDeclarationEdit = declarationEdit;
            this.fOccurenceEdits = occurenceEdits;
        }
    }

    private static class ProblemNodeFinder {
        private ProblemNodeFinder() {
        }

        public static SimpleName[] getProblemNodes(ASTNode methodNode, VariableDeclaration variableNode, TextEdit[] edits, TextChange change) {
            String key = variableNode.resolveBinding().getKey();
            NameNodeVisitor visitor = new NameNodeVisitor(edits, change, key);
            methodNode.accept((ASTVisitor)visitor);
            return visitor.getProblemNodes();
        }

        private static class NameNodeVisitor
        extends ASTVisitor {
            private Collection<IRegion> fRanges;
            private Collection<SimpleName> fProblemNodes;
            private String fKey;

            public NameNodeVisitor(TextEdit[] edits, TextChange change, String key) {
                Assert.isNotNull((Object)edits);
                Assert.isNotNull((Object)key);
                this.fRanges = new HashSet<IRegion>(Arrays.asList(RefactoringAnalyzeUtil.getNewRanges(edits, change)));
                this.fProblemNodes = new ArrayList<SimpleName>(0);
                this.fKey = key;
            }

            public SimpleName[] getProblemNodes() {
                return this.fProblemNodes.toArray(new SimpleName[this.fProblemNodes.size()]);
            }

            public boolean visit(SimpleName node) {
                VariableDeclaration decl = RenameAnalyzeUtil.getVariableDeclaration((Name)node);
                if (decl == null) {
                    return super.visit(node);
                }
                IVariableBinding binding = decl.resolveBinding();
                if (binding == null) {
                    return super.visit(node);
                }
                boolean keysEqual = this.fKey.equals(binding.getKey());
                boolean rangeInSet = this.fRanges.contains(new Region(node.getStartPosition(), node.getLength()));
                if (keysEqual && !rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                if (!keysEqual && rangeInSet) {
                    this.fProblemNodes.add(node);
                }
                return super.visit(node);
            }
        }
    }
}

