/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.qvt.oml.blackbox.java.Module;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;

@Module(packageURIs={"http://www.eclipse.org/emf/2002/Ecore"})
public class TypeLibrary {
    private static final HashMap<Class<?>, Class<?>> PRIMITIVE_TYPE_WRAPPERS = new HashMap(8);

    static {
        PRIMITIVE_TYPE_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TYPE_WRAPPERS.put(Void.TYPE, Void.TYPE);
    }

    @Operation(contextual=true)
    public Object valueOf(EClassifier self, String value) {
        Class<?> type = self.getInstanceClass();
        if (String.class.equals((Object)type)) {
            return value;
        }
        if (type.isPrimitive()) {
            type = PRIMITIVE_TYPE_WRAPPERS.get(type);
        }
        Exception cause = null;
        try {
            try {
                Method m = type.getMethod("valueOf", String.class);
                return m.invoke(null, value);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> c = type.getConstructor(String.class);
                return c.newInstance(value);
            }
        }
        catch (Exception e) {
            cause = e;
            throw new IllegalArgumentException("Failed to convert value " + value + " to type: " + self.getInstanceClassName(), cause);
        }
    }

    @Operation(contextual=true)
    public <T> T removeFirst(List<T> self) {
        return (T)(self.isEmpty() ? OCLStandardLibraryImpl.INVALID : self.remove(0));
    }

    @Operation(contextual=true)
    public <T> boolean remove(List<T> self, Object o) {
        return self.remove(o);
    }

    @Operation(contextual=true)
    public Collection<EObject> loadResource(String self, Resource context) {
        if (context == null || context.getResourceSet() == null) {
            throw new IllegalArgumentException("The context resource is not loaded in a resource set");
        }
        URI uri = URI.createURI((String)self);
        uri = uri.resolve(context.getURI());
        Resource loadedResource = context.getResourceSet().getResource(uri, true);
        return loadedResource.getContents();
    }
}

