/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.lsat.common.emf.common.util.URIHelper;

public class LargeFilePlatformResourceURIHandler
extends PlatformResourceURIHandlerImpl {
    public static final URIHandler INSTANCE = new LargeFilePlatformResourceURIHandler();

    public static final URIConverter registerTo(URIConverter uriConverter) {
        uriConverter.getURIHandlers().add(0, (Object)INSTANCE);
        return uriConverter;
    }

    public boolean canHandle(URI uri) {
        return uri.isPlatformResource() && URIHelper.asFile(uri) != null;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        final File file = URIHelper.asFile(uri);
        String parent = file.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        }
        final Map response = this.getResponse(options);
        FileOutputStream outputStream = new FileOutputStream(file){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (response != null) {
                        response.put("TIME_STAMP", file.lastModified());
                    }
                }
            }
        };
        return outputStream;
    }
}

