/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates;

import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.common.java.Strings;

public class VariableWrapper {
    public final Declaration decl;
    public final boolean isDerivative;

    public VariableWrapper(Declaration decl, boolean isDerivative) {
        this.decl = decl;
        this.isDerivative = decl instanceof ContVariable && isDerivative;
    }

    public boolean isAlgebraic() {
        return this.decl instanceof AlgVariable;
    }

    public boolean isDerivative() {
        return this.isDerivative && this.decl instanceof ContVariable;
    }

    public int hashCode() {
        if (this.decl == null) {
            return 381;
        }
        return this.decl.hashCode() + (this.isDerivative ? 1 : 0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableWrapper)) {
            return false;
        }
        VariableWrapper otherVw = (VariableWrapper)other;
        if (this.decl == null || otherVw.decl == null) {
            return this.decl == null && otherVw.decl == null;
        }
        return this.decl == otherVw.decl && this.isDerivative == otherVw.isDerivative;
    }

    public static VariableWrapper makeVariableWrapper(Expression expr) {
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression varExpr = (DiscVariableExpression)expr;
            return new VariableWrapper((Declaration)varExpr.getVariable(), false);
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariableExpression varExpr = (AlgVariableExpression)expr;
            return new VariableWrapper((Declaration)varExpr.getVariable(), false);
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression varExpr = (ContVariableExpression)expr;
            return new VariableWrapper((Declaration)varExpr.getVariable(), varExpr.isDerivative());
        }
        if (expr instanceof TimeExpression) {
            return new VariableWrapper(null, false);
        }
        throw new RuntimeException("Unexpected variable expression node " + Strings.str((Object)expr));
    }

    public String toString() {
        if (this.decl instanceof ContVariable) {
            return Strings.fmt((String)"Wrapped(\"%s\", %s)", (Object[])new Object[]{this.decl.getName(), this.isDerivative});
        }
        return Strings.fmt((String)"Wrapped(\"%s\")", (Object[])new Object[]{this.decl.getName()});
    }
}

