/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class AssignmentUniquenessChecker {
    private AssignmentUniquenessChecker() {
    }

    public static void checkUniqueAsgns(List<Update> updates, Map<Declaration, Set<Pair<Position, List<Object>>>> asgnMap, CifTypeChecker tchecker, ErrMsg errMsg) {
        for (Update update : updates) {
            if (update instanceof Assignment) {
                Assignment asgn = (Assignment)update;
                AssignmentUniquenessChecker.checkUniqueAsgns(asgn.getAddressable(), asgnMap, tchecker, errMsg);
                continue;
            }
            if (update instanceof IfUpdate) {
                IfUpdate ifUpd = (IfUpdate)update;
                Map asgnMapNew = Maps.map();
                LinkedHashMap thensMap = Maps.copy(asgnMap);
                AssignmentUniquenessChecker.checkUniqueAsgns((List<Update>)ifUpd.getThens(), (Map<Declaration, Set<Pair<Position, List<Object>>>>)thensMap, tchecker, errMsg);
                AssignmentUniquenessChecker.mergeUniqueAsgnInfos(asgnMapNew, thensMap);
                LinkedHashMap elsesMap = Maps.copy(asgnMap);
                AssignmentUniquenessChecker.checkUniqueAsgns((List<Update>)ifUpd.getElses(), (Map<Declaration, Set<Pair<Position, List<Object>>>>)elsesMap, tchecker, errMsg);
                AssignmentUniquenessChecker.mergeUniqueAsgnInfos(asgnMapNew, elsesMap);
                for (ElifUpdate elifUpd : ifUpd.getElifs()) {
                    LinkedHashMap elifMap = Maps.copy((Map)asgnMap);
                    AssignmentUniquenessChecker.checkUniqueAsgns((List<Update>)elifUpd.getThens(), (Map<Declaration, Set<Pair<Position, List<Object>>>>)elifMap, tchecker, errMsg);
                    AssignmentUniquenessChecker.mergeUniqueAsgnInfos(asgnMapNew, elifMap);
                }
                asgnMap = asgnMapNew;
                continue;
            }
            throw new RuntimeException("Unknown update: " + update);
        }
    }

    private static void mergeUniqueAsgnInfos(Map<Declaration, Set<Pair<Position, List<Object>>>> first, Map<Declaration, Set<Pair<Position, List<Object>>>> second) {
        for (Map.Entry<Declaration, Set<Pair<Position, List<Object>>>> se : second.entrySet()) {
            Declaration var = se.getKey();
            Set<Pair<Position, List<Object>>> sv = se.getValue();
            Set<Pair<Position, List<Object>>> fv = first.get(var);
            if (fv == null) {
                first.put(var, sv);
                continue;
            }
            fv.addAll(sv);
        }
    }

    public static void checkUniqueAsgns(Expression addr, Map<Declaration, Set<Pair<Position, List<Object>>>> asgnMap, CifTypeChecker tchecker, ErrMsg errMsg) {
        if (addr instanceof TupleExpression) {
            TupleExpression taddr = (TupleExpression)addr;
            for (Expression elem : taddr.getFields()) {
                AssignmentUniquenessChecker.checkUniqueAsgns(elem, asgnMap, tchecker, errMsg);
            }
            return;
        }
        AssignmentUniquenessChecker.checkUniqueAsgn(addr, asgnMap, tchecker, errMsg);
    }

    private static void checkUniqueAsgn(Expression addr, Map<Declaration, Set<Pair<Position, List<Object>>>> asgnMap, CifTypeChecker tchecker, ErrMsg errMsg) {
        DiscVariable var;
        Expression varRef = CifAddressableUtils.stripProjs((Expression)addr);
        if (varRef instanceof DiscVariableExpression) {
            var = ((DiscVariableExpression)varRef).getVariable();
        } else if (varRef instanceof ContVariableExpression) {
            var = ((ContVariableExpression)varRef).getVariable();
        } else {
            if (varRef instanceof ReceivedExpression) {
                throw new RuntimeException("Not allowed by parser.");
            }
            String msg = "Unknown addr ref expr: " + varRef;
            throw new RuntimeException(msg);
        }
        List projs = CifAddressableUtils.collectProjs((Expression)addr);
        List indices = Lists.listc((int)projs.size());
        int i = 0;
        while (i < projs.size()) {
            ProjectionExpression proj = (ProjectionExpression)projs.get(i);
            Object index = null;
            Expression idxExpr = proj.getIndex();
            CifType nctype = CifTypeUtils.normalizeType((CifType)proj.getChild().getType());
            if (idxExpr instanceof FieldExpression) {
                Field field = ((FieldExpression)idxExpr).getField();
                TupleType ttype = (TupleType)field.eContainer();
                index = ttype.getFields().indexOf((Object)field);
                Assert.check(((Integer)index >= 0 ? 1 : 0) != 0);
            } else if (CifExprsTypeChecker.checkStaticEvaluable(idxExpr, null)) {
                try {
                    index = CifEvalUtils.eval((Expression)idxExpr, (boolean)false);
                }
                catch (CifEvalException e) {
                    tchecker.addProblem(ErrMsg.EVAL_FAILURE, e.expr.getPosition(), e.getMessage());
                    throw new SemanticException();
                }
            }
            if (index != null && !(nctype instanceof TupleType)) {
                if (nctype instanceof ListType) {
                    int idx = (Integer)index;
                    if (idx < 0) {
                        int upper;
                        ListType ltype = (ListType)nctype;
                        int lower = CifTypeUtils.getLowerBound((ListType)ltype);
                        index = lower == (upper = CifTypeUtils.getUpperBound((ListType)ltype)) ? Integer.valueOf(lower + idx) : null;
                    }
                } else if (!(nctype instanceof DictType)) {
                    if (nctype instanceof StringType) {
                        return;
                    }
                    throw new RuntimeException("Unexpected proj: " + nctype);
                }
            }
            indices.add(index);
            ++i;
        }
        Set others = asgnMap.get(var);
        if (others == null) {
            others = Sets.set();
            asgnMap.put((Declaration)var, others);
        }
        boolean reported = false;
        for (Pair other : others) {
            List otherIndices = (List)other.right;
            int cnt = Math.max(indices.size(), otherIndices.size());
            boolean overlap = true;
            int i2 = 0;
            while (i2 < cnt) {
                if (i2 >= indices.size() || i2 >= otherIndices.size()) break;
                Object thisIdx = indices.get(i2);
                Object otherIdx = otherIndices.get(i2);
                if (thisIdx != null && otherIdx != null && !thisIdx.equals(otherIdx)) {
                    overlap = false;
                    break;
                }
                ++i2;
            }
            if (!overlap) continue;
            reported = true;
            String varName = CifTextUtils.getAbsName((PositionObject)var);
            String curTxt = AssignmentUniquenessChecker.varProjsToStr(varName, indices);
            String otherTxt = AssignmentUniquenessChecker.varProjsToStr(varName, otherIndices);
            tchecker.addProblem(errMsg, (Position)other.left, varName, otherTxt, curTxt);
            tchecker.addProblem(errMsg, varRef.getPosition(), varName, curTxt, otherTxt);
            break;
        }
        if (!reported) {
            others.add(Pair.pair((Object)varRef.getPosition(), (Object)indices));
        }
    }

    private static String varProjsToStr(String varName, List<Object> idxs) {
        if (idxs.isEmpty()) {
            return varName;
        }
        StringBuilder txt = new StringBuilder(varName);
        for (Object idx : idxs) {
            txt.append("[");
            txt.append(idx == null ? "..." : CifEvalUtils.objToStr((Object)idx));
            txt.append("]");
        }
        return txt.toString();
    }
}

