/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Lists;

public class PlcProject
extends PlcObject {
    public static final int INDENT = 4;
    public final String name;
    public List<PlcTypeDecl> typeDecls = Lists.list();
    public List<PlcPou> pous = Lists.list();
    public List<PlcConfiguration> configurations = Lists.list();

    public PlcProject(String name) {
        this.name = name;
    }

    public Box toBox() {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("PROJECT %s", new Object[]{this.name});
        c.indent();
        for (PlcTypeDecl typeDecl : this.typeDecls) {
            c.add(typeDecl.toBox());
        }
        for (PlcPou pou : this.pous) {
            c.add(pou.toBox());
        }
        for (PlcConfiguration configuration : this.configurations) {
            c.add(configuration.toBox());
        }
        c.dedent();
        c.add("END_PROJECT");
        return c;
    }
}

