/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcGlobalVarList
extends PlcObject {
    public final String name;
    public final boolean constants;
    public List<PlcVariable> variables = Lists.list();

    public PlcGlobalVarList(String name, boolean constants) {
        this.name = name;
        this.constants = constants;
    }

    public Box toBox() {
        Assert.check((!this.variables.isEmpty() ? 1 : 0) != 0);
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("VAR_GLOBAL%s // %s", new Object[]{this.constants ? " CONSTANT" : "", this.name});
        c.indent();
        for (PlcVariable variable : this.variables) {
            c.add((Boxable)variable);
        }
        c.dedent();
        c.add("END_VAR");
        return c;
    }
}

