/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.options;

import org.eclipse.escet.cif.cif2plc.options.PlcNumberBits;
import org.eclipse.escet.common.app.framework.exceptions.InvalidOptionException;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class PlcNumberBitsOption
extends EnumOption<PlcNumberBits> {
    public PlcNumberBitsOption() {
        super("PLC number bits", "BITS is the maximum number of bits supported by the PLC for representing numeric values. Allowed values are \"32\" and\"64\". [DEFAULT=64]", Character.valueOf('b'), "number-bits", "BITS", (Enum)PlcNumberBits.BITS_64, true, "The maximum number of bits supported by the PLC for representing numeric values.");
    }

    protected String getDialogText(PlcNumberBits value) {
        switch (value) {
            case BITS_32: {
                return "32-bit";
            }
            case BITS_64: {
                return "64-bit";
            }
        }
        throw new RuntimeException("Unknown number of bits: " + (Object)((Object)value));
    }

    public PlcNumberBits parseValue(String optName, String value) {
        if (value.equals("32")) {
            return PlcNumberBits.BITS_32;
        }
        if (value.equals("64")) {
            return PlcNumberBits.BITS_64;
        }
        throw new InvalidOptionException("Unknown option value.");
    }

    public String[] getCmdLine(Object value) {
        String valueTxt;
        switch ((PlcNumberBits)((Object)value)) {
            case BITS_32: {
                valueTxt = "32";
                break;
            }
            case BITS_64: {
                valueTxt = "64";
                break;
            }
            default: {
                throw new RuntimeException("Unknown PLC number bits value.");
            }
        }
        return new String[]{"--" + this.cmdLong + "=" + valueTxt};
    }

    public static PlcNumberBits getNumberBits() {
        return (PlcNumberBits)((Object)Options.get(PlcNumberBitsOption.class));
    }
}

