/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors;

import activity.Activity;
import activity.Claim;
import activity.PeripheralAction;
import activity.Release;
import activity.ResourceAction;
import com.google.common.base.Objects;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditingDomain;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ResourceThroughputTableContentProvider
implements IStructuredContentProvider {
    private final String resourceFqn;

    public ResourceThroughputTableContentProvider(String resourceFqn) {
        this.resourceFqn = resourceFqn;
    }

    public Object[] getElements(Object editingDomain) {
        if (editingDomain instanceof ResourceThroughputEditingDomain) {
            Functions.Function1 _function = it -> ResourceThroughputTableContentProvider.getResourceActions(it, this.resourceFqn);
            return (Object[])Conversions.unwrapArray((Object)Queries.objectsOfKind((Iterable)Queries.collect(ResourceThroughputTableContentProvider.getResourceActivities(((ResourceThroughputEditingDomain)((Object)editingDomain)).getActivities(), this.resourceFqn), (Functions.Function1)_function), PeripheralAction.class), Object.class);
        }
        throw new IllegalArgumentException();
    }

    public static Iterable<Activity> getResourceActivities(Iterable<Activity> activities, String resourceFqn) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> {
                String _fqn = it_1.getResource().fqn();
                return Objects.equal((Object)_fqn, (Object)resourceFqn);
            };
            return IterableExtensions.exists((Iterable)Queries.objectsOfKind((Iterable)it.getNodes(), ResourceAction.class), (Functions.Function1)_function_1);
        };
        return Queries.select(activities, (Functions.Function1)_function);
    }

    public static Iterable<Node> getResourceActions(Activity activity, String resourceFqn) {
        Functions.Function1 _function = it -> {
            String _fqn = it.getResource().fqn();
            return Objects.equal((Object)_fqn, (Object)resourceFqn);
        };
        Iterable claim = Queries.select((Iterable)Queries.objectsOfKind((Iterable)activity.getNodes(), Claim.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = n -> {
            Functions.Function1 _function_2 = it -> it.getTargetNode();
            return Queries.collectOne((Iterable)n.getOutgoingEdges(), (Functions.Function1)_function_2);
        };
        Set claimOutgoingNodes = IterableExtensions.toSet((Iterable)Queries.closure((Iterable)claim, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> {
            String _fqn = it.getResource().fqn();
            return Objects.equal((Object)_fqn, (Object)resourceFqn);
        };
        Iterable release = Queries.select((Iterable)Queries.objectsOfKind((Iterable)activity.getNodes(), Release.class), (Functions.Function1)_function_2);
        Functions.Function1 _function_3 = n -> {
            Functions.Function1 _function_4 = it -> it.getSourceNode();
            return Queries.collectOne((Iterable)n.getIncomingEdges(), (Functions.Function1)_function_4);
        };
        Set releaseIncomingNodes = IterableExtensions.toSet((Iterable)Queries.closure((Iterable)release, (Functions.Function1)_function_3));
        Functions.Function1 _function_4 = it -> claimOutgoingNodes.contains(it) && releaseIncomingNodes.contains(it);
        return Queries.select((Iterable)EdgQueries.topologicalOrdering((Iterable)activity.getNodes()), (Functions.Function1)_function_4);
    }
}

