/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.InputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompiler;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaFileManager;

public class OsgiClassFileObject
extends SimpleJavaFileObject {
    protected final String absClassName;
    protected final URI osgiUri;
    private final ClassLoader osgiLoader;

    public OsgiClassFileObject(String absClassName, URI uri, ClassLoader osgiLoader) {
        super(RuntimeJavaCompiler.createURI(absClassName), JavaFileObject.Kind.CLASS);
        this.absClassName = absClassName = RuntimeJavaFileManager.normalizeName(absClassName);
        this.osgiUri = uri;
        this.osgiLoader = osgiLoader;
    }

    @Override
    public String getName() {
        return String.valueOf(this.absClassName.replace(".", "/")) + ".class";
    }

    @Override
    public InputStream openInputStream() {
        return this.osgiLoader.getResourceAsStream(this.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OsgiClassFileObject)) {
            return false;
        }
        OsgiClassFileObject other = (OsgiClassFileObject)obj;
        return this.absClassName.equals(other.absClassName) && this.osgiUri.equals(other.osgiUri);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.absClassName.hashCode() ^ this.osgiUri.hashCode();
    }
}

