/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.common.app.framework.exceptions.ApplicationException;
import org.eclipse.escet.common.app.framework.exceptions.DependencyException;
import org.eclipse.escet.common.app.framework.options.GuiMode;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;

public class SWTDisplayThread
extends Thread {
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final AtomicBoolean isDisplayThread = new AtomicBoolean(false);
    private final AtomicReference<ApplicationException> error = new AtomicReference();
    private Display display;

    private SWTDisplayThread() {
        super("SWTDisplayThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        failed = false;
        try {
            this.display = Display.getDefault();
        }
        catch (UnsatisfiedLinkError | SWTError ex) {
            msg = "Failed to obtain SWT display. If running headless (without a display), make sure to connect a display (e.g. on Linux enable X11 server/forwarding), or disable GUI functionality (\"--gui=off\" command line option).";
            this.error.set(new DependencyException(msg, ex));
            failed = true;
        }
        if (!failed) {
            thisThread = Thread.currentThread();
            this.isDisplayThread.set(thisThread == (displayThread = this.display.getThread()));
        }
        var2_3 = this.ready;
        synchronized (var2_3) {
            this.ready.set(true);
            this.ready.notify();
        }
        if (!failed && this.isDisplayThread.get()) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
lbl25:
            // 3 sources

            ** while (!this.display.isDisposed())
        }
lbl26:
        // 1 sources

    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Boolean, SWTDisplayThread> create(GuiMode mode) {
        boolean guiAvailable;
        SWTDisplayThread thread = new SWTDisplayThread();
        thread.start();
        AtomicBoolean atomicBoolean = thread.ready;
        synchronized (atomicBoolean) {
            while (!thread.ready.get()) {
                try {
                    thread.ready.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (thread.error.get() == null) {
            guiAvailable = true;
        } else {
            switch (mode) {
                case ON: {
                    throw thread.error.get();
                }
                case AUTO: {
                    guiAvailable = false;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown GUI mode: " + (Object)((Object)mode));
                }
            }
        }
        SWTDisplayThread swtThread = thread.isDisplayThread.get() ? thread : null;
        Assert.implies((swtThread != null ? 1 : 0) != 0, (boolean)guiAvailable);
        Assert.implies((mode == GuiMode.ON ? 1 : 0) != 0, (boolean)guiAvailable);
        Assert.implies((!guiAvailable ? 1 : 0) != 0, (mode == GuiMode.AUTO ? 1 : 0) != 0);
        return Pair.pair((Object)guiAvailable, (Object)swtThread);
    }

    public void close() {
        if (this.display.isDisposed()) {
            return;
        }
        final Display d = this.display;
        d.syncExec(new Runnable(){

            @Override
            public void run() {
                if (d.isDisposed()) {
                    return;
                }
                d.close();
            }
        });
    }
}

